/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class SystemTraceNodeModelHChartColors {
    SystemTraceNodeModelHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (!(model instanceof SystemTraceNodeModel)) {
            throw new IllegalStateException("Model must be an instance of SystemTraceNodeModel.");
        }
    }

    static Color getIdleCpuColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = JBColor.isBright() ? ColorUtil.darker((Color)DataVisualizationColors.INSTANCE.getColor(index, isFocused), (int)5) : ColorUtil.brighter((Color)DataVisualizationColors.INSTANCE.getColor(index, isFocused), (int)5);
            if (isDeselected && !isFocused) {
                color = DataVisualizationColors.INSTANCE.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER_IDLE : ProfilerColors.CPU_FLAMECHART_APP_IDLE;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        SystemTraceNodeModelHChartColors.validateModel(model);
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = DataVisualizationColors.INSTANCE.getColor(index, isFocused);
            if (isDeselected && !isFocused) {
                color = DataVisualizationColors.INSTANCE.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getTextColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isDeselected) {
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            return isDeselected ? DataVisualizationColors.INSTANCE.getFontColor("Gray") : DataVisualizationColors.INSTANCE.getFontColor(index);
        }
        return DataVisualizationColors.DEFAULT_DARK_TEXT_COLOR;
    }
}

