/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.ThreadState;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class ThreadCellRenderer
extends CpuCellRenderer<CpuThreadsModel.RangedCpuThread, ThreadState> {
    @NotNull
    private final Map<StateChart<ThreadState>, EnumColors<ThreadState>> myColors = new HashMap<StateChart<ThreadState>, EnumColors<ThreadState>>();

    public ThreadCellRenderer(JList<CpuThreadsModel.RangedCpuThread> list, UpdatableManager updatableManager) {
        super(list);
    }

    @Override
    @NotNull
    StateChart<ThreadState> getChartForModel(@NotNull CpuThreadsModel.RangedCpuThread model) {
        return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getId())).getChart();
    }

    @Override
    public Component getListCellRendererComponent(JList list, CpuThreadsModel.RangedCpuThread value, int index, boolean isSelected, boolean cellHasFocus) {
        Icon reorderIcon = StudioIcons.Common.REORDER;
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel2.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel2.setPreferredSize((Dimension)JBDimension.create((Dimension)panel2.getPreferredSize()).withHeight(21));
        panel2.setBackground(list.getBackground());
        this.myLabel.setText(value.getName());
        this.myLabel.setIcon(null);
        JBEmptyBorder iconIndent = JBUI.Borders.emptyLeft((int)(reorderIcon.getIconWidth() + this.myLabel.getIconTextGap()));
        this.myLabel.setBorder(new CompoundBorder((Border)iconIndent, ProfilerLayout.CPU_THREADS_RIGHT_BORDER));
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        int tid = value.getThreadId();
        StateChartModel<ThreadState> model = value.getModel();
        StateChart<ThreadState> stateChart = this.getOrCreateStateChart(tid, model);
        stateChart.setOpaque(true);
        stateChart.setBorder(null);
        this.myColors.get(stateChart).setColorIndex(0);
        if (isSelected) {
            this.myLabel.setBackground(ProfilerColors.CPU_THREAD_SELECTED_BACKGROUND);
            this.myLabel.setForeground(ProfilerColors.SELECTED_THREAD_LABEL_TEXT);
            stateChart.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_THREAD_SELECTED_BACKGROUND, (int)2));
        }
        if (this.myHoveredIndex == index) {
            this.myLabel.setBorder(ProfilerLayout.CPU_THREADS_RIGHT_BORDER);
            this.myLabel.setIcon(isSelected ? ColoredIconGenerator.generateWhiteIcon((Icon)reorderIcon) : reorderIcon);
        }
        panel2.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel2.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel2;
    }

    private StateChart<ThreadState> getOrCreateStateChart(int tid, StateChartModel<ThreadState> model) {
        if (this.myStateCharts.containsKey(tid) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(tid)).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(tid)).getChart();
        }
        final EnumColors enumColors = ProfilerColors.THREAD_STATES.build();
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<ThreadState>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull ThreadState value) {
                enumColors.setColorIndex(isMouseOver ? 1 : 0);
                return enumColors.getColor((Enum)value);
            }
        });
        CpuCellRenderer.StateChartData<ThreadState> data = new CpuCellRenderer.StateChartData<ThreadState>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(tid, data);
        this.myColors.put((StateChart<ThreadState>)stateChart, (EnumColors<ThreadState>)enumColors);
        return stateChart;
    }
}

