/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JComponent {
    @NotNull
    private JLabel myDurationLabel = new JLabel();
    @NotNull
    private final String myStatus;
    @NotNull
    private final StatusPanelModel myModel;
    private final AspectObserver myObserver = new AspectObserver();
    private final JButton myAbortButton;

    public StatusPanel(@NotNull StatusPanelModel captureHandler, @NotNull String status, @Nullable String abortText) {
        this.myModel = captureHandler;
        this.myStatus = status;
        this.myModel.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateDuration);
        this.myAbortButton = abortText != null ? this.createAbortButton(abortText) : null;
        this.populateContent();
    }

    public void setAbortButtonEnabled(boolean enabled) {
        if (this.myAbortButton == null) {
            return;
        }
        this.myAbortButton.setEnabled(enabled);
    }

    private void populateContent() {
        JPanel mainPanel = new JPanel((LayoutManager)new TabularLayout("*,300px,*", "*,150px,*"));
        JPanel statusPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit,20px,Fit,*", "28px,Fit,Fit,Fit,Fit,*").setVGap(JBUI.scale((int)5)));
        statusPanel.setBorder(new LineBorder(ProfilerColors.CPU_CAPTURE_STATUS, 1));
        JLabel status = StatusPanel.createLabel("Status", true);
        JLabel actualStatus = StatusPanel.createLabel(this.myStatus, false);
        JLabel duration = StatusPanel.createLabel("Duration", true);
        JLabel technology = StatusPanel.createLabel("Type", true);
        JLabel actualTechnology = StatusPanel.createLabel(this.myModel.getConfigurationText(), false);
        statusPanel.add((Component)status, new TabularLayout.Constraint(1, 1));
        statusPanel.add((Component)actualStatus, new TabularLayout.Constraint(1, 3));
        statusPanel.add((Component)duration, new TabularLayout.Constraint(2, 1));
        statusPanel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(2, 3));
        statusPanel.add((Component)technology, new TabularLayout.Constraint(3, 1));
        statusPanel.add((Component)actualTechnology, new TabularLayout.Constraint(3, 3));
        statusPanel.add((Component)this.createButtonPanel(), new TabularLayout.Constraint(4, 3, 1));
        mainPanel.add((Component)statusPanel, new TabularLayout.Constraint(1, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    private void updateDuration() {
        this.myDurationLabel.setText(this.getDurationText());
    }

    private static JLabel createLabel(String text, boolean isRightAligned) {
        JLabel label = new JLabel(text, isRightAligned ? 4 : 2);
        label.setFont(ProfilerFonts.STANDARD_FONT);
        label.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        label.setBorder((Border)JBUI.Borders.empty());
        return label;
    }

    private JPanel createButtonPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("Fit", "4px,*"));
        if (this.myAbortButton != null) {
            panel2.add((Component)this.myAbortButton, new TabularLayout.Constraint(1, 0));
        }
        return panel2;
    }

    @VisibleForTesting
    JLabel getDurationLabel() {
        return this.myDurationLabel;
    }

    @NotNull
    private String getDurationText() {
        return TimeFormatter.getMultiUnitDurationString((long)TimeUnit.NANOSECONDS.toMicros((long)this.myModel.getRange().getLength()));
    }

    private JButton createAbortButton(@NotNull String abortText) {
        JButton abortButton = new JButton(abortText);
        abortButton.addActionListener(event -> {
            this.myModel.abort();
            abortButton.setEnabled(false);
        });
        return abortButton;
    }
}

