/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class InMemoryDataSeries<T>
implements DataSeries<T> {
    InMemoryDataSeries() {
    }

    public List<SeriesData<T>> getDataForRange(Range range) {
        ArrayList<SeriesData<T>> result = new ArrayList<SeriesData<T>>();
        List<SeriesData<T>> seriesDataList = this.inMemoryDataList();
        if (seriesDataList.isEmpty() || range.isEmpty()) {
            return result;
        }
        SeriesData minSearchKey = new SeriesData((long)range.getMin(), null);
        SeriesData maxSearchKey = new SeriesData((long)range.getMax(), null);
        int minIndex = Collections.binarySearch(seriesDataList, minSearchKey, Comparator.comparingLong(o -> o.x));
        int maxIndex = Collections.binarySearch(seriesDataList, maxSearchKey, Comparator.comparingLong(o -> o.x));
        if (minIndex < 0) {
            minIndex = Math.max(-minIndex - 2, 0);
        }
        if (maxIndex < 0) {
            maxIndex = Math.min(-maxIndex - 1, seriesDataList.size() - 1);
        }
        result.addAll(seriesDataList.subList(minIndex, maxIndex + 1));
        return result;
    }

    @NotNull
    protected abstract List<SeriesData<T>> inMemoryDataList();
}

