/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.util.SwingUtil;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.capturedetails.CodeNavigationHandler;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableList;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadTrackRenderer
implements TrackRenderer<CpuThreadTrackModel, ProfilerTrackRendererType> {
    @NotNull
    private final AspectObserver myObserver = new AspectObserver();
    @NotNull
    private final StudioProfilersView myProfilersView;

    public CpuThreadTrackRenderer(@NotNull StudioProfilersView profilersView) {
        this.myProfilersView = profilersView;
    }

    @NotNull
    public JComponent render(final @NotNull TrackModel<CpuThreadTrackModel, ProfilerTrackRendererType> trackModel) {
        final HTreeChart<CaptureNode> traceEventChart = this.createHChart(((CpuThreadTrackModel)trackModel.getDataModel()).getCallChartModel(), ((CpuThreadTrackModel)trackModel.getDataModel()).getCapture().getRange(), trackModel.isCollapsed());
        final MultiSelectionModel<CpuAnalyzable> multiSelectionModel = ((CpuThreadTrackModel)trackModel.getDataModel()).getMultiSelectionModel();
        multiSelectionModel.addDependency(this.myObserver).onChange((Enum)MultiSelectionModel.Aspect.CHANGE_SELECTION, () -> {
            ImmutableList selection2 = multiSelectionModel.getSelection();
            if (!selection2.isEmpty() && selection2.get(0) instanceof CaptureNodeAnalysisModel) {
                traceEventChart.setSelectedNode((HNode)((CaptureNodeAnalysisModel)selection2.get(0)).getNode());
            } else {
                traceEventChart.setSelectedNode(null);
            }
        });
        final StateChart<ThreadState> threadStateChart = CpuThreadTrackRenderer.createStateChart(((CpuThreadTrackModel)trackModel.getDataModel()).getThreadStateChartModel());
        JPanel panel2 = new JPanel();
        if (trackModel.isCollapsed() || threadStateChart == null) {
            panel2.setLayout((LayoutManager)new TabularLayout("*", "*"));
            panel2.add((Component)traceEventChart, new TabularLayout.Constraint(0, 0));
        } else {
            panel2.setLayout((LayoutManager)new TabularLayout("*", "8px,*"));
            panel2.add((Component)threadStateChart, new TabularLayout.Constraint(0, 0));
            panel2.add((Component)traceEventChart, new TabularLayout.Constraint(1, 0));
        }
        if (!trackModel.isCollapsed()) {
            panel2.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (threadStateChart != null && threadStateChart.contains(e.getPoint())) {
                        trackModel.setActiveTooltipModel((TooltipModel)((CpuThreadTrackModel)trackModel.getDataModel()).getThreadStateTooltip());
                        threadStateChart.dispatchEvent((AWTEvent)e);
                    } else if (traceEventChart.contains(e.getPoint())) {
                        Point p = e.getPoint();
                        p.translate(-traceEventChart.getX(), -traceEventChart.getY());
                        CaptureNode node = (CaptureNode)traceEventChart.getNodeAt(p);
                        if (node == null) {
                            trackModel.setActiveTooltipModel(null);
                        } else {
                            trackModel.setActiveTooltipModel((TooltipModel)((CpuThreadTrackModel)trackModel.getDataModel()).getTraceEventTooltipBuilder().apply(node));
                        }
                        traceEventChart.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventPoint((MouseEvent)e, (Point)p));
                    } else {
                        trackModel.setActiveTooltipModel(null);
                    }
                }
            });
            panel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (traceEventChart.contains(e.getPoint())) {
                        Point p = e.getPoint();
                        p.translate(-traceEventChart.getX(), -traceEventChart.getY());
                        CaptureNode node = (CaptureNode)traceEventChart.getNodeAt(p);
                        if (node != null) {
                            multiSelectionModel.setSelection(Collections.singleton(new CaptureNodeAnalysisModel(node, ((CpuThreadTrackModel)trackModel.getDataModel()).getCapture())));
                        } else {
                            multiSelectionModel.clearSelection();
                        }
                        traceEventChart.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventPoint((MouseEvent)e, (Point)p));
                    }
                }
            });
        }
        return panel2;
    }

    @Nullable
    private static StateChart<ThreadState> createStateChart(@NotNull StateChartModel<ThreadState> model) {
        if (model.getSeries().isEmpty()) {
            return null;
        }
        StateChart threadStateChart = new StateChart(model, (StateChartColorProvider)new CpuThreadColorProvider());
        threadStateChart.setHeightGap(0.0f);
        return threadStateChart;
    }

    private HTreeChart<CaptureNode> createHChart(@NotNull CaptureDetails.CallChart callChartModel, @NotNull Range captureRange, boolean isCollapsed) {
        CaptureNode node = callChartModel.getNode();
        Range selectionRange = callChartModel.getRange();
        HTreeChart.Builder builder = new HTreeChart.Builder((HNode)node, selectionRange, (HRenderer)new CaptureNodeHRenderer(CaptureDetails.Type.CALL_CHART)).setGlobalXRange(captureRange).setOrientation(HTreeChart.Orientation.TOP_DOWN).setRootVisible(false).setNodeSelectionEnabled(true);
        if (isCollapsed) {
            return builder.setCustomNodeHeightPx(1).setNodeYPaddingPx(0).build();
        }
        HTreeChart chart = builder.build();
        if (callChartModel.getCapture().getSystemTraceData() == null) {
            CodeNavigator navigator = this.myProfilersView.getStudioProfilers().getStage().getStudioProfilers().getIdeServices().getCodeNavigator();
            CodeNavigationHandler handler = new CodeNavigationHandler((HTreeChart<CaptureNode>)chart, navigator);
            chart.addMouseListener((MouseListener)handler);
            this.myProfilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, handler::getCodeLocation);
        }
        if (node != null) {
            node.getAspectModel().addDependency(this.myObserver).onChange((Enum)CaptureNode.Aspect.FILTER_APPLIED, () -> chart.setHTree((HNode)node));
        }
        return chart;
    }

    private static class CpuThreadColorProvider
    extends StateChartColorProvider<ThreadState> {
        private final EnumColors<ThreadState> myEnumColors = ProfilerColors.THREAD_STATES.build();

        private CpuThreadColorProvider() {
        }

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull ThreadState value) {
            this.myEnumColors.setColorIndex(isMouseOver ? 1 : 0);
            return this.myEnumColors.getColor((Enum)value);
        }
    }
}

