/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.cpu.CpuFramesCellRenderer;
import com.android.tools.profilers.cpu.CpuListScrollPane;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class CpuFramesView {
    @NotNull
    private final HideablePanel myPanel;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final CpuFramesCellRenderer myRenderer;
    @NotNull
    private JBList<CpuFramesModel.FrameState> myFrames;

    public CpuFramesView(@NotNull CpuProfilerStage stage) {
        this.myFrames = new JBList((ListModel)stage.getFramesModel());
        this.myStage = stage;
        this.myPanel = this.createPanel();
        this.setupListeners();
        this.myFrames.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myRenderer = new CpuFramesCellRenderer(this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig(), (JList<CpuFramesModel.FrameState>)this.myFrames);
        this.myFrames.setCellRenderer((ListCellRenderer)this.myRenderer);
        this.myFrames.setVisibleRowCount(2);
        this.myStage.getFramesModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                int size = CpuFramesView.this.myStage.getFramesModel().getSize();
                boolean hasElements = size != 0;
                CpuFramesView.this.myPanel.setVisible(hasElements);
                CpuFramesView.this.myPanel.setExpanded(hasElements);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        DelegateMouseEventHandler.delegateTo((Component)this.myPanel).installListenerOn(this.myFrames).installMotionListenerOn(this.myFrames);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupListeners() {
        this.myFrames.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CpuFramesView.this.frameSelected();
            }
        });
        this.myFrames.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuFrameTooltip((Timeline)this.myStage.getTimeline())));
        this.myFrames.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = CpuFramesView.this.myFrames.locationToIndex(e.getPoint());
                if (row != -1) {
                    CpuFramesModel.FrameState model = (CpuFramesModel.FrameState)CpuFramesView.this.myStage.getFramesModel().getElementAt(row);
                    if (CpuFramesView.this.myStage.getTooltip() instanceof CpuFrameTooltip) {
                        CpuFrameTooltip tooltip2 = (CpuFrameTooltip)CpuFramesView.this.myStage.getTooltip();
                        tooltip2.setFrameSeries(model.getSeries());
                    }
                    CpuFramesView.this.frameHighlighted(model);
                } else {
                    CpuFramesView.this.myRenderer.setHighlightedFrame(SystemTraceFrame.EMPTY);
                }
            }
        });
        this.myFrames.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                CpuFramesView.this.myRenderer.setHighlightedFrame(SystemTraceFrame.EMPTY);
            }
        });
    }

    private void frameHighlighted(@NotNull CpuFramesModel.FrameState model) {
        Range tooltipRange = this.myStage.getTimeline().getTooltipRange();
        List modelList = ((RangedSeries)model.getModel().getSeries().get(0)).getSeriesForRange(tooltipRange);
        if (modelList.isEmpty()) {
            this.myRenderer.setHighlightedFrame(SystemTraceFrame.EMPTY);
            return;
        }
        this.myRenderer.setHighlightedFrame((SystemTraceFrame)((Object)((SeriesData)modelList.get((int)0)).value));
    }

    @NotNull
    private HideablePanel createPanel() {
        JPanel frames = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        HideablePanel framesPanel = new HideablePanel.Builder("FRAMES", (JComponent)frames).setShowSeparator(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).setInitiallyExpanded(false).setIconTextGap(6).setTitleLeftPadding(7).build();
        CpuListScrollPane scrollingFrames = new CpuListScrollPane((JList)this.myFrames, (JComponent)framesPanel);
        frames.add((Component)((Object)scrollingFrames), new TabularLayout.Constraint(0, 0));
        frames.setBorder((Border)JBUI.Borders.empty());
        framesPanel.setVisible(false);
        framesPanel.setBorder((Border)JBUI.Borders.empty());
        framesPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        return framesPanel;
    }

    private void frameSelected() {
        int selectedIndex = this.myFrames.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        CpuFramesModel.FrameState state = (CpuFramesModel.FrameState)this.myFrames.getModel().getElementAt(selectedIndex);
        Range tooltipRange = this.myStage.getTimeline().getTooltipRange();
        List process = ((RangedSeries)state.getModel().getSeries().get(0)).getSeriesForRange(tooltipRange);
        if (process.isEmpty() || ((SeriesData)process.get((int)0)).value == SystemTraceFrame.EMPTY) {
            return;
        }
        this.myStage.getTimeline().getSelectionRange().set((double)((SeriesData)process.get((int)0)).x, (double)(((SeriesData)process.get((int)0)).x + ((SystemTraceFrame)((Object)((SeriesData)process.get((int)0)).value)).getDurationUs()));
        this.myStage.setSelectedThread(state.getThreadId());
    }
}

