/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Notification {
    @NotNull
    private final Severity mySeverity;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myText;
    @Nullable
    private final UrlData myUrlData;

    private Notification(@NotNull Builder builder) {
        this.mySeverity = builder.mySeverity;
        this.myTitle = builder.myTitle;
        this.myText = builder.myText;
        this.myUrlData = builder.myUrlData;
    }

    @NotNull
    public Severity getSeverity() {
        return this.mySeverity;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public UrlData getUrlData() {
        return this.myUrlData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return this.mySeverity == that.mySeverity && Objects.equals(this.myTitle, that.myTitle) && Objects.equals(this.myText, that.myText) && Objects.equals(this.myUrlData, that.myUrlData);
    }

    public int hashCode() {
        return Objects.hash(this.myText, this.myTitle, this.myText, this.myUrlData);
    }

    public static final class UrlData {
        @NotNull
        private final String myUrl;
        @NotNull
        private final String myText;

        public UrlData(@NotNull String url, @NotNull String text) {
            this.myUrl = url;
            this.myText = text;
        }

        @NotNull
        public String getUrl() {
            return this.myUrl;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlData urlData = (UrlData)o;
            return Objects.equals(this.myUrl, urlData.myUrl) && Objects.equals(this.myText, urlData.myText);
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myText);
        }
    }

    public static final class Builder {
        @NotNull
        private Severity mySeverity = Severity.INFO;
        @NotNull
        private final String myTitle;
        @NotNull
        private final String myText;
        @Nullable
        private UrlData myUrlData;

        public Builder(@NotNull String title, @NotNull String text) {
            this.myTitle = title;
            this.myText = text;
        }

        @NotNull
        public Builder setSeverity(@NotNull Severity severity) {
            this.mySeverity = severity;
            return this;
        }

        @NotNull
        public Builder setUrlData(@NotNull UrlData urlData) {
            this.myUrlData = urlData;
            return this;
        }

        @NotNull
        public Builder setUrl(@NotNull String url, @NotNull String text) {
            return this.setUrlData(new UrlData(url, text));
        }

        @NotNull
        public Notification build() {
            return new Notification(this);
        }
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR;

    }
}

