/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EnergyTable
extends DataStoreTable<EventStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Energy_Sample", "Session INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Sample BLOB NOT NULL");
            this.createTable("Energy_Event", "Session INTEGER NOT NULL", "Id INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "IsTerminal BIT NOT NULL", "Event BLOB NOT NULL");
            this.createUniqueIndex("Energy_Sample", "Session", "Timestamp");
            this.createUniqueIndex("Energy_Event", "Session", "Id", "Timestamp");
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(EventStatements.INSERT_SAMPLE, "INSERT OR REPLACE INTO Energy_Sample (Session, Timestamp, Sample) values (?, ?, ?)");
            this.createStatement(EventStatements.INSERT_EVENT, "INSERT OR REPLACE INTO Energy_Event (Session, Id, Timestamp, IsTerminal, Event) values (?, ?, ?, ?, ?)");
            this.createStatement(EventStatements.QUERY_SAMPLE, "SELECT Sample from Energy_Sample WHERE Session = ? AND Timestamp >= ? AND Timestamp < ?;");
            this.createStatement(EventStatements.QUERY_EVENT, "SELECT Latest_Events.Event, Latest_Events.Timestamp  FROM   (SELECT Event, Id, MAX(Timestamp) AS Timestamp, IsTerminal    FROM Energy_Event    WHERE Session = ? AND TimeStamp < ?    GROUP BY Id) AS Latest_Events  WHERE IsTerminal = 0 UNION SELECT Event, Timestamp FROM Energy_Event  WHERE Session = ? AND Timestamp >= ? AND Timestamp < ?ORDER BY Timestamp;");
            this.createStatement(EventStatements.QUERY_EVENT_GROUP, "SELECT Event, Timestamp FROM Energy_Event  WHERE Session = ? AND Id = ?ORDER BY Timestamp;");
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
        }
    }

    public void insertOrReplace(@NotNull Common.Session session, @NotNull EnergyProfiler.EnergySample sample) {
        this.execute(EventStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertOrReplace(@NotNull Common.Session session, @NotNull Common.Event event) {
        this.execute(EventStatements.INSERT_EVENT, session.getSessionId(), event.getGroupId(), event.getTimestamp(), event.getIsEnded(), event.toByteArray());
    }

    @NotNull
    public List<EnergyProfiler.EnergySample> getSamples(@NotNull EnergyProfiler.EnergyRequest request) {
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_SAMPLE, request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            return EnergyTable.getSamplesFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            return new ArrayList<EnergyProfiler.EnergySample>();
        }
    }

    @NotNull
    public List<Common.Event> getEvents(@NotNull EnergyProfiler.EnergyRequest request) {
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_EVENT, request.getSession().getSessionId(), request.getStartTimestamp(), request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            return EnergyTable.getEventsFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            return new ArrayList<Common.Event>();
        }
    }

    @NotNull
    public List<Common.Event> getEventGroup(@NotNull EnergyProfiler.EnergyEventGroupRequest request) {
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_EVENT_GROUP, request.getSession().getSessionId(), request.getEventId());
            return EnergyTable.getEventsFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            return new ArrayList<Common.Event>();
        }
    }

    @NotNull
    private static List<EnergyProfiler.EnergySample> getSamplesFromResultSet(@NotNull ResultSet results) {
        ArrayList<EnergyProfiler.EnergySample> samples = new ArrayList<EnergyProfiler.EnergySample>();
        try {
            while (results.next()) {
                EnergyProfiler.EnergySample.Builder sampleBuilder = EnergyProfiler.EnergySample.newBuilder();
                sampleBuilder.mergeFrom(results.getBytes(1));
                samples.add(sampleBuilder.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EnergyTable.onError(ex);
        }
        return samples;
    }

    @NotNull
    private static List<Common.Event> getEventsFromResultSet(@NotNull ResultSet results) {
        ArrayList<Common.Event> events = new ArrayList<Common.Event>();
        try {
            while (results.next()) {
                Common.Event.Builder eventBuilder = Common.Event.newBuilder();
                eventBuilder.mergeFrom(results.getBytes(1));
                events.add(eventBuilder.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EnergyTable.onError(ex);
        }
        return events;
    }

    public static enum EventStatements {
        INSERT_SAMPLE,
        QUERY_SAMPLE,
        INSERT_EVENT,
        QUERY_EVENT,
        QUERY_EVENT_GROUP;

    }
}

