/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.EmptyResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class DataStoreTable<T extends Enum> {
    private static final Set<DataStoreTableErrorCallback> ERROR_CALLBACKS = ConcurrentHashMap.newKeySet();
    private Connection myConnection;
    private final ThreadLocal<Map<T, PreparedStatement>> myStatementMap = new ThreadLocal();
    private final ThreadLocal<Map<String, PreparedStatement>> myCustomQueryCache = new ThreadLocal();

    public void initialize(@NotNull Connection connection) {
        this.myConnection = connection;
    }

    public abstract void prepareStatements();

    public static void addDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        ERROR_CALLBACKS.add(callback);
    }

    public static void removeDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        ERROR_CALLBACKS.remove(callback);
    }

    public boolean isClosed() {
        try {
            return this.myConnection.isClosed();
        }
        catch (SQLException ex) {
            return true;
        }
    }

    protected static void onError(Throwable t) {
        for (DataStoreTableErrorCallback callback : ERROR_CALLBACKS) {
            callback.onDataStoreError(t);
        }
    }

    @NotNull
    protected Map<T, PreparedStatement> getStatementMap() {
        if (this.myStatementMap.get() == null) {
            this.myStatementMap.set(new HashMap());
            this.prepareStatements();
        }
        return this.myStatementMap.get();
    }

    protected void createTable(@NotNull String table, String ... columns) throws SQLException {
        this.myConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s ", table));
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE TABLE %s", table));
        this.executeUniqueStatement(statement, columns);
    }

    protected void createUniqueIndex(@NotNull String table, String ... indexList) throws SQLException {
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE UNIQUE INDEX IF NOT EXISTS idx_%s_pk ON %s", table, table));
        this.executeUniqueStatement(statement, indexList);
    }

    protected void createIndex(@NotNull String table, int indexId, String ... indexList) throws SQLException {
        StringBuilder statement = new StringBuilder();
        statement.append(String.format(Locale.US, "CREATE INDEX IF NOT EXISTS idx_%s_%d_pk ON %s", table, indexId, table));
        this.executeUniqueStatement(statement, indexList);
    }

    private void executeUniqueStatement(@NotNull StringBuilder statement, @NotNull String[] params) throws SQLException {
        this.myConnection.createStatement().execute(String.format("%s ( %s )", statement, String.join((CharSequence)",", params)));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt) throws SQLException {
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt, int statementFlags) throws SQLException {
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt, statementFlags));
    }

    protected <K> void executeBatch(@NotNull T statement, @NotNull List<K> batchParams, @NotNull Function<K, Object[]> paramConverter) {
        if (this.isClosed()) {
            return;
        }
        try {
            PreparedStatement stmt = this.getStatementMap().get(statement);
            batchParams.forEach(object -> {
                try {
                    this.applyParams(stmt, (Object[])paramConverter.apply(object));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    DataStoreTable.onError(ex);
                }
            });
            int[] results = stmt.executeBatch();
            for (int i2 = 0; i2 < results.length; ++i2) {
                if (results[i2] != -3) continue;
                throw new SQLException(String.format("Failed to insert batch element %d with result %d", i2, results[i2]));
            }
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
        }
    }

    protected void execute(@NotNull T statement, Object ... params) {
        if (this.isClosed()) {
            return;
        }
        try {
            PreparedStatement stmt = this.getStatementMap().get(statement);
            this.applyParams(stmt, params);
            stmt.execute();
            stmt.clearParameters();
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
        }
    }

    protected ResultSet executeQuery(@NotNull T statement, Object ... params) throws SQLException {
        if (this.isClosed()) {
            return new EmptyResultSet();
        }
        PreparedStatement stmt = this.getStatementMap().get(statement);
        this.applyParams(stmt, params);
        return stmt.executeQuery();
    }

    protected ResultSet executeOneTimeQuery(@NotNull String sql, Object[] params) throws SQLException {
        Map<String, PreparedStatement> queryCache;
        if (this.isClosed()) {
            return new EmptyResultSet();
        }
        if (this.myCustomQueryCache.get() == null) {
            this.myCustomQueryCache.set(new HashMap());
        }
        if (!(queryCache = this.myCustomQueryCache.get()).containsKey(sql)) {
            queryCache.put(sql, this.myConnection.prepareStatement(sql));
        }
        PreparedStatement statement = queryCache.get(sql);
        this.applyParams(statement, params);
        return statement.executeQuery();
    }

    protected void applyParams(@NotNull PreparedStatement statement, Object ... params) throws SQLException {
        for (int i2 = 0; params != null && i2 < params.length; ++i2) {
            if (params[i2] == null) continue;
            if (params[i2] instanceof String) {
                statement.setString(i2 + 1, (String)params[i2]);
                continue;
            }
            if (params[i2] instanceof Integer) {
                statement.setLong(i2 + 1, ((Integer)params[i2]).intValue());
                continue;
            }
            if (params[i2] instanceof Long) {
                statement.setLong(i2 + 1, (Long)params[i2]);
                continue;
            }
            if (params[i2] instanceof byte[]) {
                statement.setBytes(i2 + 1, (byte[])params[i2]);
                continue;
            }
            if (params[i2] instanceof Boolean) {
                statement.setBoolean(i2 + 1, (Boolean)params[i2]);
                continue;
            }
            assert (false) : "No DataStoreTable support for arguments of type: " + params[i2].getClass();
        }
    }

    public static interface DataStoreTableErrorCallback {
        public void onDataStoreError(Throwable var1);
    }
}

