/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import com.jetbrains.jsonSchema.remote.JsonSchemaRemoteContentProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCatalogManager {
    static final String DEFAULT_CATALOG = "http://schemastore.org/api/json/catalog.json";
    static final String DEFAULT_CATALOG_HTTPS = "https://schemastore.azurewebsites.net/api/json/catalog.json";
    private static final Set<String> SCHEMA_URLS_WITH_TOO_MANY_VARIANTS = ImmutableSet.of((Object)"https://raw.githubusercontent.com/microsoft/azure-pipelines-vscode/master/service-schema.json");
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaRemoteContentProvider myRemoteContentProvider;
    @Nullable
    private VirtualFile myCatalog = null;
    @NotNull
    private final ConcurrentMap<String, String> myResolvedMappings = new ConcurrentHashMap<String, String>();
    private static final String NO_CACHE = "$_$_WS_NO_CACHE_$_$";
    private static final String EMPTY = "$_$_WS_EMPTY_$_$";
    private final Map<Runnable, FileDownloadingAdapter> myDownloadingAdapters = ContainerUtil.createConcurrentWeakMap();

    public JsonSchemaCatalogManager(@NotNull Project project) {
        this.myProject = project;
        this.myRemoteContentProvider = new JsonSchemaRemoteContentProvider();
    }

    public void startUpdates() {
        JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).addChangeHandler(() -> {
            this.update();
            JsonSchemaService.Impl.get(this.myProject).reset();
        });
        RemoteFileManager instance = RemoteFileManager.getInstance();
        instance.addRemoteContentProvider((RemoteContentProvider)this.myRemoteContentProvider);
        this.update();
    }

    private void update() {
        this.myCatalog = !JsonFileResolver.isRemoteEnabled(this.myProject) ? null : JsonFileResolver.urlToFile(DEFAULT_CATALOG);
    }

    @Nullable
    public VirtualFile getSchemaFileForFile(@NotNull VirtualFile file) {
        if (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isCatalogEnabled()) {
            return null;
        }
        if (JsonSchemaCatalogExclusion.EP_NAME.findFirstSafe(exclusion -> exclusion.isExcluded(file)) != null) {
            return null;
        }
        String name = file.getName();
        String schemaUrl = null;
        if (this.myResolvedMappings.containsKey(name)) {
            schemaUrl = (String)this.myResolvedMappings.get(name);
            if (EMPTY.equals(schemaUrl)) {
                return null;
            }
        } else if (this.myCatalog != null) {
            schemaUrl = JsonSchemaCatalogManager.resolveSchemaFile(file, this.myCatalog, this.myProject);
            if (NO_CACHE.equals(schemaUrl)) {
                return null;
            }
            this.myResolvedMappings.put(name, StringUtil.notNullize((String)schemaUrl, (String)EMPTY));
        }
        if (SCHEMA_URLS_WITH_TOO_MANY_VARIANTS.contains(schemaUrl)) {
            return null;
        }
        return JsonFileResolver.resolveSchemaByReference(file, schemaUrl);
    }

    public List<JsonSchemaCatalogEntry> getAllCatalogEntries() {
        if (this.myCatalog != null) {
            List<JsonSchemaCatalogEntry> catalog = JsonCachedValues.getSchemaCatalog(this.myCatalog, this.myProject);
            return catalog == null ? ContainerUtil.emptyList() : catalog;
        }
        return ContainerUtil.emptyList();
    }

    public void registerCatalogUpdateCallback(final Runnable callback) {
        RemoteFileInfo info;
        if (this.myCatalog instanceof HttpVirtualFile && (info = ((HttpVirtualFile)this.myCatalog).getFileInfo()) != null) {
            FileDownloadingAdapter adapter = new FileDownloadingAdapter(){

                public void fileDownloaded(@NotNull VirtualFile localFile) {
                    callback.run();
                }
            };
            this.myDownloadingAdapters.put(callback, adapter);
            info.addDownloadingListener((FileDownloadingListener)adapter);
        }
    }

    public void unregisterCatalogUpdateCallback(Runnable callback) {
        RemoteFileInfo info;
        if (!this.myDownloadingAdapters.containsKey(callback)) {
            return;
        }
        if (this.myCatalog instanceof HttpVirtualFile && (info = ((HttpVirtualFile)this.myCatalog).getFileInfo()) != null) {
            info.removeDownloadingListener((FileDownloadingListener)this.myDownloadingAdapters.get(callback));
        }
    }

    public void triggerUpdateCatalog(Project project) {
        JsonFileResolver.startFetchingHttpFileIfNeeded(this.myCatalog, project);
    }

    @Nullable
    private static String resolveSchemaFile(@NotNull VirtualFile file, @NotNull VirtualFile catalogFile, @NotNull Project project) {
        JsonFileResolver.startFetchingHttpFileIfNeeded(catalogFile, project);
        List<JsonSchemaCatalogEntry> schemaCatalog = JsonCachedValues.getSchemaCatalog(catalogFile, project);
        if (schemaCatalog == null) {
            return catalogFile instanceof HttpVirtualFile ? NO_CACHE : null;
        }
        String fileName = file.getName();
        for (JsonSchemaCatalogEntry maskAndPath : schemaCatalog) {
            if (!JsonSchemaCatalogManager.matches(fileName, maskAndPath.getFileMasks())) continue;
            return maskAndPath.getUrl();
        }
        return null;
    }

    private static boolean matches(@NotNull String fileName, @NotNull Collection<String> masks) {
        for (String mask : masks) {
            if (!JsonSchemaCatalogManager.matches(fileName, mask)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(@NotNull String fileName, @NotNull String mask) {
        if (mask.equals(fileName)) {
            return true;
        }
        int star = mask.indexOf(42);
        if (star == -1) {
            return false;
        }
        if (star == 0 && fileName.startsWith(mask.substring(1))) {
            return true;
        }
        if (star == mask.length() - 1 && fileName.endsWith(mask.substring(0, mask.length() - 1))) {
            return true;
        }
        String beforeStar = mask.substring(0, star);
        String afterStar = mask.substring(star + 1);
        return fileName.startsWith(beforeStar) && fileName.endsWith(afterStar);
    }
}

