/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonSchemaBasedInspectionBase
extends LocalInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        VirtualFile virtualFile;
        JsonValue root;
        PsiFile file = holder.getFile();
        Collection<PsiElement> allRoots = JsonOriginalPsiWalker.INSTANCE.getRoots(file);
        JsonValue jsonValue = root = allRoots.size() == 1 ? (JsonValue)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(allRoots), JsonValue.class) : null;
        if (root == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(file.getProject());
        if (!service.isApplicableToFile(virtualFile = file.getViewProvider().getVirtualFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return this.doBuildVisitor(root, service.getSchemaObject(file), service, holder, session);
    }

    protected abstract PsiElementVisitor doBuildVisitor(@NotNull JsonValue var1, @Nullable JsonSchemaObject var2, @NotNull JsonSchemaService var3, @NotNull ProblemsHolder var4, @NotNull LocalInspectionToolSession var5);
}

