/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonElementImpl;
import com.intellij.json.psi.impl.JsonPropertyNameReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class JsonPropertyMixin
extends JsonElementImpl
implements JsonProperty {
    JsonPropertyMixin(@NotNull ASTNode node) {
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        JsonElementGenerator generator = new JsonElementGenerator(this.getProject());
        this.getNameElement().replace(generator.createStringLiteral(StringUtil.unquoteString((String)name)));
        return this;
    }

    public PsiReference getReference() {
        return new JsonPropertyNameReference(this);
    }

    public PsiReference @NotNull [] getReferences() {
        Object[] fromProviders = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        return (PsiReference[])ArrayUtil.prepend((Object)new JsonPropertyNameReference(this), (Object[])fromProviders);
    }
}

