/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonElementTypes;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    private static final int SKIP_WRAPPING = -2;

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (isSoftWrap) {
            return super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, true);
        }
        if (project == null) {
            return -1;
        }
        int wrapPosition = JsonLineWrapPositionStrategy.getMinWrapPosition(document, project, maxPreferredOffset);
        if (wrapPosition == -2) {
            return -1;
        }
        int minWrapPosition = Math.max(startOffset, wrapPosition);
        return super.calculateWrapPosition(document, project, minWrapPosition, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
    }

    private static int getMinWrapPosition(@NotNull Document document, @NotNull Project project, int offset) {
        PsiFile psiFile;
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        if (manager.isUncommited(document)) {
            manager.commitDocument(document);
        }
        if ((psiFile = manager.getPsiFile(document)) != null) {
            PsiElement currElement = psiFile.findElementAt(offset);
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)currElement);
            if (elementType == JsonElementTypes.DOUBLE_QUOTED_STRING || elementType == JsonElementTypes.SINGLE_QUOTED_STRING || elementType == JsonElementTypes.LITERAL || elementType == JsonElementTypes.BOOLEAN_LITERAL || elementType == JsonElementTypes.TRUE || elementType == JsonElementTypes.FALSE || elementType == JsonElementTypes.IDENTIFIER || elementType == JsonElementTypes.NULL_LITERAL || elementType == JsonElementTypes.NUMBER_LITERAL) {
                return currElement.getTextRange().getEndOffset();
            }
            if (elementType == JsonElementTypes.COLON) {
                return -2;
            }
            if (currElement != null && (currElement instanceof PsiComment || PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesForward((PsiElement)currElement)) == JsonElementTypes.COMMA)) {
                return -2;
            }
        }
        return -1;
    }
}

