/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    private static final String COMMENT = "$comment";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        final boolean isSchemaFile = JsonSchemaService.isSchemaFile(holder.getFile());
        return new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o) {
                MultiMap keys = new MultiMap();
                for (JsonProperty property : o.getPropertyList()) {
                    keys.putValue((Object)property.getName(), (Object)property.getNameElement());
                }
                for (Map.Entry entry : keys.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry.getValue();
                    String entryKey = (String)entry.getKey();
                    if (sameNamedKeys.size() <= 1 || isSchemaFile && JsonDuplicatePropertyKeysInspection.COMMENT.equalsIgnoreCase(entryKey)) continue;
                    for (PsiElement element : sameNamedKeys) {
                        holder.registerProblem(element, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entryKey), new LocalQuickFix[]{new NavigateToDuplicatesFix(sameNamedKeys, element, entryKey)});
                    }
                }
            }
        };
    }

    private static class NavigateToDuplicatesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @NotNull
        private final Collection<SmartPsiElementPointer> mySameNamedKeys;
        @NotNull
        private final String myEntryKey;

        private NavigateToDuplicatesFix(@NotNull Collection<PsiElement> sameNamedKeys, @NotNull PsiElement element, @NotNull String entryKey) {
            super(element);
            this.mySameNamedKeys = ContainerUtil.map(sameNamedKeys, k -> SmartPointerManager.createPointer((PsiElement)k));
            this.myEntryKey = entryKey;
        }

        @NotNull
        public String getText() {
            return JsonBundle.message("navigate.to.duplicates", new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, final @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (editor == null) {
                return;
            }
            if (this.mySameNamedKeys.size() == 2) {
                PsiElement toNavigate;
                Iterator<SmartPsiElementPointer> iterator = this.mySameNamedKeys.iterator();
                PsiElement next = iterator.next().getElement();
                PsiElement psiElement = toNavigate = next != startElement ? next : iterator.next().getElement();
                if (toNavigate == null) {
                    return;
                }
                NavigateToDuplicatesFix.navigateTo(editor, toNavigate);
            } else {
                List allElements = this.mySameNamedKeys.stream().map(k -> k.getElement()).filter(k -> k != startElement).collect(Collectors.toList());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiElement>(JsonBundle.message("navigate.to.duplicates.header", this.myEntryKey), allElements){

                    @NotNull
                    public Icon getIconFor(PsiElement aValue) {
                        return AllIcons.Nodes.Property;
                    }

                    @NotNull
                    public String getTextFor(PsiElement value) {
                        return JsonBundle.message("navigate.to.duplicates.desc", myEntryKey, editor.getDocument().getLineNumber(value.getTextOffset()));
                    }

                    public int getDefaultOptionIndex() {
                        return 0;
                    }

                    @Nullable
                    public PopupStep onChosen(PsiElement selectedValue, boolean finalChoice) {
                        NavigateToDuplicatesFix.navigateTo(editor, selectedValue);
                        return PopupStep.FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }
                }).showInBestPositionFor(editor);
            }
        }

        private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement toNavigate) {
            editor.getCaretModel().moveToOffset(toNavigate.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }
}

