/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlEmptyObjectAdapter
implements JsonObjectValueAdapter {
    private final PsiElement myElement;

    public YamlEmptyObjectAdapter(PsiElement element) {
        this.myElement = element;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        return ContainerUtil.emptyList();
    }

    public boolean isNull() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.myElement;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public JsonSchemaType getAlternateType(JsonSchemaType type) {
        return type == JsonSchemaType._object ? JsonSchemaType._null : type;
    }
}

