/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.resolve.YAMLAliasReference;

public class YAMLUnresolvedAliasInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new YamlPsiElementVisitor(){

            @Override
            public void visitAlias(@NotNull YAMLAlias alias) {
                YAMLAliasReference reference = alias.getReference();
                if (reference != null && reference.resolve() == null) {
                    holder.registerProblem((PsiReference)reference, YAMLBundle.message("inspections.unresolved.alias.message", alias.getAliasName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }
}

