/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.formatter.YAMLFormattingContext;
import org.jetbrains.yaml.formatter.YAMLFormattingModelBuilder;

class YAMLFormattingBlock
extends AbstractBlock {
    @NotNull
    private final YAMLFormattingContext myContext;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Indent myNewChildIndent;
    private final boolean myIsIncomplete;
    @NotNull
    private final TextRange myTextRange;

    YAMLFormattingBlock(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        super(node, null, context.computeAlignment(node));
        this.myContext = context;
        this.myIndent = this.myContext.computeBlockIndent(this.myNode);
        this.myIsIncomplete = this.myContext.isIncomplete(this.myNode);
        this.myNewChildIndent = this.myContext.computeNewChildIndent(this.myNode);
        this.myTextRange = YAMLFormattingBlock.excludeTrailingEOLs(this.myNode);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return this.myContext.computeSpacing((Block)this, child1, child2);
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isIncomplete() {
        return this.myIsIncomplete;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myTextRange;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.myNewChildIndent;
    }

    protected List<Block> buildChildren() {
        return YAMLFormattingBlock.buildSubBlocks(this.myContext, this.myNode);
    }

    @NotNull
    private static List<Block> buildSubBlocks(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        SmartList res = new SmartList();
        for (ASTNode subNode = node.getFirstChildNode(); subNode != null; subNode = subNode.getTreeNext()) {
            IElementType subNodeType = PsiUtilCore.getElementType((ASTNode)subNode);
            if (YAMLElementTypes.SPACE_ELEMENTS.contains(subNodeType)) continue;
            if (YAMLElementTypes.CONTAINERS.contains(subNodeType)) {
                res.addAll(YAMLFormattingBlock.buildSubBlocks(context, subNode));
                continue;
            }
            res.add(YAMLFormattingModelBuilder.createBlock(context, subNode));
        }
        return res;
    }

    private static TextRange excludeTrailingEOLs(@NotNull ASTNode node) {
        CharSequence text = node.getChars();
        int last = text.length() - 1;
        if (last == -1 || text.charAt(last) != '\n') {
            return node.getTextRange();
        }
        for (int i = last; i >= 0; --i) {
            if (text.charAt(i) == '\n') continue;
            int start = node.getTextRange().getStartOffset();
            return new TextRange(start, start + i + 1);
        }
        return node.getTextRange();
    }
}

