/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;

public class YAMLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        commonSettings.SPACE_WITHIN_BRACES = true;
        commonSettings.SPACE_WITHIN_BRACKETS = true;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new YAMLIndentOptionsEditor(this);
    }

    @NotNull
    public Language getLanguage() {
        return YAMLLanguage.INSTANCE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE", "KEEP_INDENTS_ON_EMPTY_LINES"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_WITHIN_BRACES", "SPACE_WITHIN_BRACKETS"});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "SPACE_BEFORE_COLON", "Before ':'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_LINE_BREAKS"});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "ALIGN_VALUES_PROPERTIES", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.values", new Object[0]), null, new Object[]{Holder.ALIGN_OPTIONS, Holder.ALIGN_VALUES});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "SEQUENCE_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.sequence.on.new.line", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "BLOCK_MAPPING_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.block.mapping.on.new.line", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "AUTOINSERT_SEQUENCE_MARKER", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.autoinsert.sequence.marker", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
        }
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return CodeStyleAbstractPanel.readFromFile(YAMLBundle.class, (String)"indents.yml");
    }

    private static class YAMLIndentOptionsEditor
    extends SmartIndentOptionsEditor {
        private JCheckBox myIndentSequence;

        YAMLIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
            super(provider);
        }

        protected void addComponents() {
            super.addComponents();
            this.myIndentSequence = new JCheckBox(YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.indent.sequence.value", new Object[0]));
            this.add(this.myIndentSequence);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.myIndentSequence.setEnabled(enabled);
        }

        public boolean isModified(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            boolean isModified = super.isModified(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            return isModified |= YAMLIndentOptionsEditor.isFieldModified((JCheckBox)this.myIndentSequence, (boolean)yamlSettings.INDENT_SEQUENCE_VALUE);
        }

        public void apply(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            super.apply(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            yamlSettings.INDENT_SEQUENCE_VALUE = this.myIndentSequence.isSelected();
        }

        public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            super.reset(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            this.myIndentSequence.setSelected(yamlSettings.INDENT_SEQUENCE_VALUE);
        }
    }

    private static class Holder {
        private static final int[] ALIGN_VALUES = new int[]{0, 2, 1};
        private static final String[] ALIGN_OPTIONS = new String[]{YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.no", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.colon", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.value", new Object[0])};

        private Holder() {
        }
    }
}

