/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;

public class YAMLElementGenerator {
    private final Project myProject;

    public YAMLElementGenerator(Project project) {
        this.myProject = project;
    }

    public static YAMLElementGenerator getInstance(Project project) {
        return (YAMLElementGenerator)ServiceManager.getService((Project)project, YAMLElementGenerator.class);
    }

    @NotNull
    public static String createChainedKey(@NotNull List<String> keyComponents, int indentAddition) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyComponents.size(); ++i) {
            if (i > 0) {
                sb.append(StringUtil.repeatSymbol((char)' ', (int)(indentAddition + 2 * i)));
            }
            sb.append(keyComponents.get(i)).append(":");
            if (i + 1 >= keyComponents.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    public YAMLKeyValue createYamlKeyValue(@NotNull String keyName, @NotNull String valueText) {
        YAMLFile tempValueFile = this.createDummyYamlWithText(valueText);
        Collection values = PsiTreeUtil.collectElementsOfType((PsiElement)tempValueFile, (Class[])new Class[]{YAMLValue.class});
        String text = !values.isEmpty() && values.iterator().next() instanceof YAMLScalar && !valueText.contains("\n") ? keyName + ": " + valueText : keyName + ":\n" + YAMLTextUtil.indentText(valueText, 2);
        YAMLFile tempFile = this.createDummyYamlWithText(text);
        return (YAMLKeyValue)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLKeyValue.class}).iterator().next();
    }

    @NotNull
    public YAMLQuotedTextImpl createYamlDoubleQuotedString() {
        YAMLFile tempFile = this.createDummyYamlWithText("\"foo\"");
        return (YAMLQuotedTextImpl)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLQuotedTextImpl.class}).iterator().next();
    }

    @NotNull
    public YAMLFile createDummyYamlWithText(@NotNull String text) {
        return (YAMLFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)text, LocalTimeCounter.currentTime(), true);
    }

    @NotNull
    public PsiElement createEol() {
        YAMLFile file = this.createDummyYamlWithText("\n");
        return PsiTreeUtil.getDeepestFirst((PsiElement)file);
    }

    @NotNull
    public PsiElement createSpace() {
        YAMLKeyValue keyValue = this.createYamlKeyValue("foo", "bar");
        ASTNode whitespaceNode = keyValue.getNode().findChildByType(TokenType.WHITE_SPACE);
        assert (whitespaceNode != null);
        return whitespaceNode.getPsi();
    }

    @NotNull
    public PsiElement createIndent(int size) {
        YAMLFile file = this.createDummyYamlWithText(StringUtil.repeatSymbol((char)' ', (int)size));
        return PsiTreeUtil.getDeepestFirst((PsiElement)file);
    }

    @NotNull
    public PsiElement createColon() {
        YAMLFile file = this.createDummyYamlWithText("? foo : bar");
        PsiElement at = file.findElementAt("? foo ".length());
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.COLON);
        return at;
    }
}

