/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupActionScriptManager {
    public static final String STARTUP_WIZARD_MODE = "StartupWizardMode";
    public static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    public static synchronized void executeActionScript() throws IOException {
        try {
            List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(StartupActionScriptManager.getActionScriptFile());
            for (ActionCommand command : commands) {
                command.execute();
            }
        }
        finally {
            StartupActionScriptManager.saveActionScript(null);
        }
    }

    public static synchronized void executeActionScript(@NotNull File scriptFile, @NotNull File oldTarget, @NotNull File newTarget) throws IOException {
        List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(scriptFile.toPath());
        StartupActionScriptManager.executeActionScriptCommands(commands, oldTarget, newTarget);
    }

    public static void executeActionScriptCommands(List<ActionCommand> commands, @NotNull File oldTarget, @NotNull File newTarget) throws IOException {
        for (ActionCommand command : commands) {
            ActionCommand toExecute = StartupActionScriptManager.mapPaths(command, oldTarget, newTarget);
            if (toExecute == null) continue;
            toExecute.execute();
        }
    }

    public static synchronized void addActionCommand(ActionCommand command) throws IOException {
        StartupActionScriptManager.addActionCommands(Collections.singletonList(command));
    }

    public static synchronized void addActionCommands(List<? extends ActionCommand> commands) throws IOException {
        if (Boolean.getBoolean(STARTUP_WIZARD_MODE)) {
            for (ActionCommand actionCommand : commands) {
                actionCommand.execute();
            }
        } else {
            List<ActionCommand> script;
            try {
                script = StartupActionScriptManager.loadActionScript(StartupActionScriptManager.getActionScriptFile());
                script.addAll(commands);
            }
            catch (ObjectStreamException objectStreamException) {
                Logger.getInstance(StartupActionScriptManager.class).warn((Throwable)objectStreamException);
                script = new ArrayList<ActionCommand>(commands);
            }
            StartupActionScriptManager.saveActionScript(script);
        }
    }

    @NotNull
    private static Path getActionScriptFile() {
        return Paths.get(PathManager.getPluginTempPath(), ACTION_SCRIPT_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ActionCommand> loadActionScript(@NotNull Path scriptFile) throws IOException {
        if (!Files.isRegularFile(scriptFile, new LinkOption[0])) {
            return new ArrayList<ActionCommand>();
        }
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(scriptFile, new OpenOption[0]));){
            Object data = ois.readObject();
            if (data instanceof ActionCommand[]) {
                ArrayList<ActionCommand> arrayList = new ArrayList<ActionCommand>(Arrays.asList((ActionCommand[])data));
                return arrayList;
            }
            if (data instanceof List && ((List)data).size() == 0) {
                ArrayList<ActionCommand> arrayList = new ArrayList<ActionCommand>();
                return arrayList;
            }
            throw new IOException("An unexpected object: " + data + "/" + data.getClass());
        }
        catch (ReflectiveOperationException e) {
            throw (StreamCorruptedException)new StreamCorruptedException("Stream error: " + scriptFile).initCause(e);
        }
    }

    private static void saveActionScript(@Nullable List<ActionCommand> commands) throws IOException {
        Path scriptFile = StartupActionScriptManager.getActionScriptFile();
        StartupActionScriptManager.saveActionScript(commands, scriptFile);
    }

    public static void saveActionScript(@Nullable List<ActionCommand> commands, Path scriptFile) throws IOException {
        if (commands != null) {
            Files.createDirectories(scriptFile.getParent(), new FileAttribute[0]);
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(scriptFile, new OpenOption[0]));){
                oos.writeObject(commands.toArray(ActionCommand.EMPTY_ARRAY));
            }
        } else if (Files.exists(scriptFile, new LinkOption[0])) {
            FileUtilRt.delete((File)scriptFile.toFile());
        }
    }

    private static ActionCommand mapPaths(ActionCommand command, File oldTarget, File newTarget) {
        File source;
        if (command instanceof CopyCommand) {
            File destination = StartupActionScriptManager.mapPath(((CopyCommand)command).myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new CopyCommand(new File(((CopyCommand)command).mySource), destination);
            }
        } else if (command instanceof UnzipCommand) {
            File destination = StartupActionScriptManager.mapPath(((UnzipCommand)command).myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new UnzipCommand(new File(((UnzipCommand)command).mySource), destination, ((UnzipCommand)command).myFilenameFilter);
            }
        } else if (command instanceof DeleteCommand && (source = StartupActionScriptManager.mapPath(((DeleteCommand)command).mySource, oldTarget, newTarget)) != null) {
            return new DeleteCommand(source);
        }
        return null;
    }

    private static File mapPath(String path, File oldTarget, File newTarget) {
        String oldTargetPath = oldTarget.getPath();
        if (path.startsWith(oldTargetPath)) {
            if (path.length() == oldTargetPath.length()) {
                return newTarget;
            }
            if (path.charAt(oldTargetPath.length()) == File.separatorChar) {
                return new File(newTarget, path.substring(oldTargetPath.length() + 1));
            }
        }
        return null;
    }

    public static class DeleteCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;

        public DeleteCommand(@NotNull File source) {
            this.mySource = source.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            if (source.exists() && !FileUtilRt.delete((File)source)) {
                throw new IOException("Cannot delete: " + source);
            }
        }

        public String toString() {
            return "delete[" + this.mySource + "]";
        }
    }

    public static class UnzipCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;
        private final FilenameFilter myFilenameFilter;

        public UnzipCommand(@NotNull File source, @NotNull File destination) {
            this(source, destination, null);
        }

        public UnzipCommand(@NotNull File source, @NotNull File destination, FilenameFilter filenameFilter) {
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
            this.myFilenameFilter = filenameFilter;
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            if (!destination.isDirectory() && !destination.mkdirs()) {
                throw new IOException("Cannot create a directory: " + destination);
            }
            ZipUtil.extract((File)source, (File)destination, (FilenameFilter)this.myFilenameFilter);
        }

        public String toString() {
            return "unzip[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }
    }

    public static class CopyCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;

        public CopyCommand(@NotNull File source, @NotNull File destination) {
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            File destDir = destination.getParentFile();
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                throw new IOException("Cannot create a directory: " + destDir);
            }
            FileUtilRt.copy((File)source, (File)destination);
        }

        public String toString() {
            return "copy[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }
    }

    public static interface ActionCommand {
        public static final ActionCommand[] EMPTY_ARRAY = new ActionCommand[0];

        public void execute() throws IOException;
    }
}

