/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BytecodeTransformer;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BootstrapClassLoaderUtil {
    public static final String CLASSPATH_ORDER_FILE = "classpath-order.txt";
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";
    private static final String MARKETPLACE_PLUGIN_DIR = "marketplace";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static ClassLoader initClassLoader() throws MalformedURLException {
        File marketplaceImpl;
        List<String> jarOrder = BootstrapClassLoaderUtil.loadJarOrder();
        LinkedHashSet<URL> classpath = new LinkedHashSet<URL>();
        BootstrapClassLoaderUtil.addParentClasspath(classpath, false);
        BootstrapClassLoaderUtil.addIdeaLibraries(classpath, jarOrder);
        BootstrapClassLoaderUtil.addAdditionalClassPath(classpath);
        BootstrapClassLoaderUtil.addParentClasspath(classpath, true);
        File mpBoot = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-bootstrap.jar");
        boolean installMarketplace = BootstrapClassLoaderUtil.shouldInstallMarketplace(mpBoot);
        if (installMarketplace && (marketplaceImpl = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-impl.jar")).exists()) {
            classpath.add(marketplaceImpl.toURI().toURL());
        }
        UrlClassLoader.Builder builder = UrlClassLoader.build().urls(BootstrapClassLoaderUtil.filterClassPath(new ArrayList<URL>(classpath))).allowLock().usePersistentClasspathIndexForLocalClassDirectories().logJarAccess(Boolean.getBoolean("idea.log.classpath.info")).autoAssignUrlsWithProtectionDomain().useCache();
        if (Boolean.parseBoolean(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "true"))) {
            builder.allowBootstrapResources();
        }
        ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
        if (installMarketplace) {
            try {
                ArrayList<BytecodeTransformer> transformers = new ArrayList<BytecodeTransformer>();
                UrlClassLoader spiLoader = UrlClassLoader.build().urls(new URL[]{mpBoot.toURI().toURL()}).parent(BootstrapClassLoaderUtil.class.getClassLoader()).get();
                for (BytecodeTransformer transformer : ServiceLoader.load(BytecodeTransformer.class, (ClassLoader)spiLoader)) {
                    transformers.add(transformer);
                }
                if (!transformers.isEmpty()) {
                    return new TransformingLoader(builder, transformers);
                }
            }
            catch (Throwable e) {
                String path = new File(PathManager.getPluginsPath(), MARKETPLACE_PLUGIN_DIR).getAbsolutePath();
                String message = "As a workaround, you may uninstall or update JetBrains Marketplace Support plugin at " + path;
                Main.showMessage("JetBrains Marketplace boot failure", new Exception(message, e));
            }
        }
        return builder.get();
    }

    private static boolean shouldInstallMarketplace(File mpBoot) {
        block46: {
            if (!mpBoot.exists()) {
                return false;
            }
            try {
                Throwable throwable;
                BufferedReader reader2;
                Path homePath = Paths.get(PathManager.getHomePath(), new String[0]);
                SimpleVersion ideVersion = null;
                try {
                    reader2 = Files.newBufferedReader(homePath.resolve("build.txt"));
                    throwable = null;
                    try {
                        ideVersion = SimpleVersion.parse(reader2.readLine());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader2 != null) {
                            if (throwable != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader2.close();
                            }
                        }
                    }
                }
                catch (IOException reader2) {
                    // empty catch block
                }
                if (ideVersion == null && SystemInfoRt.isMac) {
                    reader2 = Files.newBufferedReader(homePath.resolve("Resources/build.txt"));
                    throwable = null;
                    try {
                        ideVersion = SimpleVersion.parse(reader2.readLine());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (reader2 != null) {
                            if (throwable != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader2.close();
                            }
                        }
                    }
                }
                if (ideVersion == null) break block46;
                SimpleVersion sinceVersion = null;
                SimpleVersion untilVersion = null;
                try (BufferedReader reader3 = Files.newBufferedReader(Paths.get(PathManager.getPluginsPath(), new String[0]).resolve(MARKETPLACE_PLUGIN_DIR).resolve("platform-build.txt"));){
                    sinceVersion = SimpleVersion.parse(reader3.readLine());
                    untilVersion = SimpleVersion.parse(reader3.readLine());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ideVersion.isCompatible(sinceVersion, untilVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    private static void addParentClasspath(Collection<URL> classpath, boolean ext) throws MalformedURLException {
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            if (!ext) {
                BootstrapClassLoaderUtil.parseClassPathString(System.getProperty("java.class.path"), classpath);
            }
        } else {
            String[] extDirs = System.getProperty("java.ext.dirs", "").split(File.pathSeparator);
            if (ext && extDirs.length == 0) {
                return;
            }
            ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>(2);
            for (ClassLoader loader = BootstrapClassLoaderUtil.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                if (loader instanceof URLClassLoader) {
                    loaders.add(0, (URLClassLoader)loader);
                    continue;
                }
                BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader: " + loader.getClass().getName());
            }
            String libPath = PathManager.getLibPath();
            for (URLClassLoader loader : loaders) {
                URL[] urls;
                for (URL url : urls = loader.getURLs()) {
                    String path = BootstrapClassLoaderUtil.urlToPath(url);
                    if (path.startsWith(libPath)) continue;
                    boolean isExt = false;
                    for (String extDir : extDirs) {
                        if (!path.startsWith(extDir) || path.length() <= extDir.length() || path.charAt(extDir.length()) != File.separatorChar) continue;
                        isExt = true;
                        break;
                    }
                    if (isExt != ext) continue;
                    classpath.add(url);
                }
            }
        }
    }

    private static String urlToPath(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI().getSchemeSpecificPart()).getPath();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url.toString());
        }
    }

    private static void addIdeaLibraries(Collection<URL> classpath, Collection<String> jarOrder) throws MalformedURLException {
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRoot != null);
        URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
        File libFolder = new File(PathManager.getLibPath());
        for (String jarName : jarOrder) {
            File jarFile;
            if (jarName == null || jarName.isEmpty() || !(jarFile = new File(libFolder, jarName)).exists()) continue;
            classpath.add(jarFile.toURI().toURL());
        }
        classpath.add(selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder, selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ext"), selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ant/lib"), selfRootUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> loadJarOrder() {
        InputStream resource = BootstrapClassLoaderUtil.class.getResourceAsStream(CLASSPATH_ORDER_FILE);
        if (resource == null) return Collections.emptyList();
        try (BufferedReader stream = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            List list = FileUtilRt.loadLines((BufferedReader)stream);
            return list;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static void addLibraries(Collection<URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            URL url;
            if (!FileUtilRt.isJarOrZip((File)file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
            classPath.add(url);
        }
    }

    private static void addAdditionalClassPath(Collection<URL> classpath) {
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH), classpath);
    }

    private static void parseClassPathString(String pathString, Collection<URL> classpath) {
        if (pathString == null || pathString.isEmpty()) {
            return;
        }
        try {
            String libPath = PathManager.getLibPath();
            StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ',', false);
            while (tokenizer.hasMoreTokens()) {
                String pathItem = tokenizer.nextToken();
                if (pathItem.startsWith(libPath)) continue;
                classpath.add(new File(pathItem).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
        }
    }

    private static List<URL> filterClassPath(List<URL> classpath) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<URL> i = classpath.iterator();
            while (i.hasNext()) {
                String url = i.next().toExternalForm();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return classpath;
    }

    private static final class SimpleVersion
    implements Comparable<SimpleVersion> {
        private final int myMajor;
        private final int myMinor;

        SimpleVersion(int major, int minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        public boolean isAtLeast(@NotNull SimpleVersion ver) {
            return ver.compareTo(this) <= 0;
        }

        public boolean isCompatible(@Nullable SimpleVersion since, @Nullable SimpleVersion until) {
            if (since != null && until != null) {
                return this.compareTo(since) >= 0 && this.compareTo(until) <= 0;
            }
            if (since != null) {
                return this.isAtLeast(since);
            }
            if (until != null) {
                return until.isAtLeast(this);
            }
            return true;
        }

        @Override
        public int compareTo(@NotNull SimpleVersion ver) {
            return this.myMajor != ver.myMajor ? Integer.compare(this.myMajor, ver.myMajor) : Integer.compare(this.myMinor, ver.myMinor);
        }

        @Nullable
        public static SimpleVersion parse(@Nullable String text) {
            if (!StringUtil.isEmpty((String)text)) {
                try {
                    int dot;
                    text = text.trim();
                    int dash = text.lastIndexOf(45);
                    if (dash >= 0) {
                        text = text.substring(dash + 1);
                    }
                    if ((dot = text.indexOf(46)) >= 0) {
                        return new SimpleVersion(Integer.parseInt(text.substring(0, dot)), SimpleVersion.parseMinor(text.substring(dot + 1)));
                    }
                    return new SimpleVersion(Integer.parseInt(text), 0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static int parseMinor(String text) {
            try {
                if ("*".equals(text) || "SNAPSHOT".equals(text)) {
                    return Integer.MAX_VALUE;
                }
                int dot = text.indexOf(46);
                return Integer.parseInt(dot >= 0 ? text.substring(0, dot) : text);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    private static class TransformingLoader
    extends UrlClassLoader {
        private final List<BytecodeTransformer> myTransformers;

        TransformingLoader(UrlClassLoader.Builder builder, List<BytecodeTransformer> transformers) {
            super(builder);
            this.myTransformers = Collections.unmodifiableList(transformers);
        }

        protected Class<?> _defineClass(String name, byte[] b) {
            return super._defineClass(name, this.doTransform(name, null, b));
        }

        protected Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
            return super._defineClass(name, this.doTransform(name, protectionDomain, b), protectionDomain);
        }

        private byte[] doTransform(String name, ProtectionDomain protectionDomain, byte[] bytes) {
            byte[] b = bytes;
            for (BytecodeTransformer transformer : this.myTransformers) {
                byte[] result = transformer.transform((ClassLoader)((Object)this), name, protectionDomain, b);
                if (result == null) continue;
                b = result;
            }
            return b;
        }
    }
}

