/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.gct.idea.git.CloudRepositoryService;
import com.google.gct.idea.resources.RepositoryModelItem;
import com.google.gct.idea.resources.ResourceEmptyModelItem;
import com.google.gct.idea.resources.ResourceErrorModelItem;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.intellij.openapi.components.ServiceManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRepositoriesModelItem
extends DefaultMutableTreeNode {
    private CloudRepositoryService cloudRepositoryService = (CloudRepositoryService)ServiceManager.getService(CloudRepositoryService.class);

    public void loadRepositories(@NotNull String cloudProject, @NotNull CredentialedUser user, @Nullable Runnable onComplete) {
        this.setUserObject(cloudProject);
        ((CompletableFuture)this.cloudRepositoryService.listAsync(user, cloudProject).thenAccept(response -> {
            this.removeAllChildren();
            List repositories = response.getRepos();
            if (!response.isEmpty() && repositories != null) {
                repositories.forEach(repo -> {
                    Object name = repo.get((Object)"name");
                    if (name != null) {
                        this.add(new RepositoryModelItem(name.toString()));
                    }
                });
            } else {
                this.add(new ResourceEmptyModelItem(GctBundle.message("cloud.repository.list.empty", new Object[0])));
            }
            if (onComplete != null) {
                onComplete.run();
            }
        })).exceptionally(response -> {
            this.removeAllChildren();
            this.add(new ResourceErrorModelItem(GctBundle.message("cloud.repository.list.error", new Object[0])));
            if (onComplete != null) {
                onComplete.run();
            }
            return null;
        });
    }
}

