/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.resources.SelectUserDialog;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.AuthData;
import git4idea.DialogManager;
import git4idea.remote.GitHttpAuthDataProvider;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GcpHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    private static final Logger LOG = Logger.getInstance(GcpHttpAuthDataProvider.class);
    public static final String GOOGLE_URL = "https://source.developers.google.com";
    public static final String GCP_USER = "com.google.gct.idea.git.username";
    private static final String GOOGLE_URL_ALT = "http://source.developers.google.com";
    private String selectedUser;
    private boolean chooseManualLogin;
    private static Project currentProject;

    @Nullable
    public AuthData getAuthData(@NotNull String url) {
        final Project currentProject = GcpHttpAuthDataProvider.getCurrentProject();
        if ((currentProject != null || Context.currentContext != null) && GcpHttpAuthDataProvider.isGcpUrl(url)) {
            CredentialedUser targetUser;
            String userEmail;
            Context currentContext = Context.currentContext;
            String string = userEmail = currentContext != null ? currentContext.userName : null;
            if (Strings.isNullOrEmpty((String)userEmail) && currentProject != null) {
                userEmail = PropertiesComponent.getInstance((Project)currentProject).getValue(GCP_USER, "");
            }
            if ((targetUser = GcpHttpAuthDataProvider.getUserFromEmail(userEmail)) == null) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SelectUserDialog dialog = new SelectUserDialog(currentProject, GctBundle.getString("httpauthprovider.chooselogin", new Object[0]));
                        DialogManager.show((DialogWrapper)dialog);
                        GcpHttpAuthDataProvider.this.chooseManualLogin = !dialog.isOK();
                        GcpHttpAuthDataProvider.this.selectedUser = dialog.getSelectedUser();
                    }
                }, ModalityState.defaultModalityState());
                if (this.chooseManualLogin) {
                    return null;
                }
                userEmail = this.selectedUser;
                targetUser = GcpHttpAuthDataProvider.getUserFromEmail(userEmail);
                if (targetUser != null && currentProject != null && Context.currentContext == null) {
                    PropertiesComponent.getInstance((Project)currentProject).setValue(GCP_USER, userEmail);
                }
            }
            if (targetUser != null) {
                try {
                    return new AuthData(targetUser.getEmail(), targetUser.getGoogleLoginState().fetchAccessToken());
                }
                catch (IOException ex) {
                    LOG.error("IOException creating authdata:" + ex.toString());
                }
            }
        }
        return null;
    }

    public static boolean isGcpUrl(@Nullable String url) {
        return url != null && (StringUtil.startsWithIgnoreCase((String)url, (String)GOOGLE_URL) || StringUtil.startsWithIgnoreCase((String)url, (String)GOOGLE_URL_ALT));
    }

    public static String getGcpUrl(String projectId, String repositoryId) {
        return "https://source.developers.google.com/p/" + projectId + "/r/" + repositoryId + "/";
    }

    @NotNull
    public static Context createContext(@Nullable String userName) {
        return Context.create(userName);
    }

    @Nullable
    private static CredentialedUser getUserFromEmail(@Nullable String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            return null;
        }
        for (CredentialedUser user : GoogleLogin.getInstance().getAllUsers().values()) {
            if (email == null || !email.equalsIgnoreCase(user.getEmail())) continue;
            return user;
        }
        return null;
    }

    public void forgetPassword(@NotNull String url) {
        Project currentProject = GcpHttpAuthDataProvider.getCurrentProject();
        if (currentProject != null) {
            PropertiesComponent.getInstance((Project)currentProject).unsetValue(GCP_USER);
        }
    }

    @Nullable
    private static Project getCurrentProject() {
        Project result = null;
        Window activeWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (activeWindow != null) {
            result = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)activeWindow));
        }
        return result != null ? result : currentProject;
    }

    public static class Context {
        private static Context currentContext = null;
        private String userName;

        private Context(@Nullable String userName) {
            this.userName = userName;
        }

        public static Context create(@Nullable String userName) {
            Context newContext = new Context(userName);
            assert (currentContext == null);
            currentContext = newContext;
            return newContext;
        }

        public void close() {
            if (currentContext == this) {
                currentContext = null;
            }
        }
    }
}

