/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LintIdeQuickFix
extends WriteActionAware {
    public static final LintIdeQuickFix[] EMPTY_ARRAY = new LintIdeQuickFix[0];

    public void apply(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.Context var3);

    public boolean isApplicable(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.ContextType var3);

    @NotNull
    public String getName();

    @Nullable
    default public String getFamilyName() {
        return null;
    }

    public static class LocalFixWrapper
    extends LocalQuickFixOnPsiElement {
        private final LintIdeQuickFix myFix;

        public LocalFixWrapper(@NotNull LintIdeQuickFix fix, @NotNull PsiElement start, @NotNull PsiElement end) {
            super(start, end);
            this.myFix = fix;
        }

        @NotNull
        public String getText() {
            return this.myFix.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.myFix.getFamilyName() != null ? this.myFix.getFamilyName() : this.myFix.getName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.myFix.apply(startElement, endElement, AndroidQuickfixContexts.BatchContext.getInstance());
        }

        public boolean startInWriteAction() {
            return this.myFix.startInWriteAction();
        }
    }

    public static class LocalFixWrappee
    implements LintIdeQuickFix {
        private final LocalQuickFixOnPsiElement myFix;

        public LocalFixWrappee(@NotNull LocalQuickFixOnPsiElement fix) {
            this.myFix = fix;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            this.myFix.invoke(startElement.getProject(), startElement.getContainingFile(), startElement, endElement);
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return startElement.isValid();
        }

        @Override
        @Nullable
        public String getFamilyName() {
            return this.myFix.getFamilyName();
        }

        @Override
        @NotNull
        public String getName() {
            return this.myFix.getName();
        }
    }
}

