/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class LintIdeGradleVisitor
extends GradleVisitor {
    private static String getClosureName(GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getDotToken() == null) {
            return invokedExpression.getReferenceName();
        }
        return null;
    }

    private static void extractMethodCallArguments(GrMethodCall methodCall, List<String> unnamed, Map<String, String> named) {
        GrArgumentList argumentList = methodCall.getArgumentList();
        for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
            if (groovyPsiElement instanceof GrNamedArgument) {
                Object value;
                GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                GrExpression expression = namedArgument.getExpression();
                if (!(expression instanceof GrLiteral) || (value = ((GrLiteral)expression).getValue()) == null) continue;
                named.put(namedArgument.getLabelName(), value.toString());
                continue;
            }
            if (!(groovyPsiElement instanceof GrExpression)) continue;
            unnamed.add(groovyPsiElement.getText());
        }
    }

    public void visitBuildScript(final @NotNull GradleContext context, final @NotNull List<? extends GradleScanner> detectors) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = LintIdeUtilsKt.getPsiFile((Context)context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    public void visitClosure(@NotNull GrClosableBlock closure) {
                        GrClosableBlock block;
                        String parentName = LintIdeGradleVisitor.getClosureName(closure);
                        String parentParentName = null;
                        if (parentName != null && (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true)) != null) {
                            parentParentName = LintIdeGradleVisitor.getClosureName(block);
                        }
                        if (parentName != null) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                GrReferenceExpression propertyRef;
                                String property;
                                GrExpression lValue;
                                GrMethodCallExpression assignment;
                                String value;
                                if (element instanceof GrApplicationStatement) {
                                    GrReferenceExpression propertyRef2;
                                    String property2;
                                    GrApplicationStatement call = (GrApplicationStatement)element;
                                    GrExpression propertyExpression = call.getInvokedExpression();
                                    GrCommandArgumentList argumentList = call.getArgumentList();
                                    if (!(propertyExpression instanceof GrReferenceExpression) || (property2 = (propertyRef2 = (GrReferenceExpression)propertyExpression).getReferenceName()) == null || argumentList == null) continue;
                                    value = argumentList.getText();
                                    for (GradleScanner detector : detectors) {
                                        detector.checkDslPropertyAssignment(context, property2, value, parentName, parentParentName, (Object)propertyRef2, (Object)argumentList, (Object)call);
                                    }
                                    continue;
                                }
                                if (element instanceof GrMethodCallExpression) {
                                    assignment = (GrMethodCallExpression)element;
                                    lValue = assignment.getInvokedExpression();
                                    if (!(lValue instanceof GrReferenceExpression) || (property = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null) continue;
                                    GrExpression[] list = assignment.getArgumentList().getExpressionArguments();
                                    if (list.length == 1) {
                                        GrExpression rValue2 = list[0];
                                        String value2 = rValue2.getText();
                                        for (GradleScanner detector : detectors) {
                                            detector.checkDslPropertyAssignment(context, property, value2, parentName, parentParentName, (Object)lValue, (Object)rValue2, (Object)assignment);
                                        }
                                        continue;
                                    }
                                    HashMap namedArguments = Maps.newHashMap();
                                    ArrayList unnamedArguments = Lists.newArrayList();
                                    LintIdeGradleVisitor.extractMethodCallArguments((GrMethodCall)assignment, unnamedArguments, namedArguments);
                                    for (GradleScanner detector : detectors) {
                                        detector.checkMethodCall(context, property, parentName, parentParentName, (Map)namedArguments, (List)unnamedArguments, (Object)assignment);
                                    }
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression) || (property = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null || (rValue = assignment.getRValue()) == null) continue;
                                value = rValue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, (Object)lValue, (Object)rValue, (Object)assignment);
                                }
                                if (parentName.equals("ext") || !property.equals("minSdkVersion") && !property.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message = String.format("Do not use assignment with the %1$s property (remove the '=')", property);
                                context.report(GradleDetector.IDE_SUPPORT, location, message, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                        GrExpression invokedExpression;
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true);
                        String parentName = block != null ? LintIdeGradleVisitor.getClosureName(block) : null;
                        String parentParentName = null;
                        if (parentName != null) {
                            GrClosableBlock outerBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)block, GrClosableBlock.class, (boolean)true);
                            parentParentName = outerBlock != null ? LintIdeGradleVisitor.getClosureName(outerBlock) : null;
                        }
                        String statementName = applicationStatement.getInvokedExpression().getText();
                        HashMap namedArguments = Maps.newHashMap();
                        ArrayList unnamedArguments = Lists.newArrayList();
                        LintIdeGradleVisitor.extractMethodCallArguments((GrMethodCall)applicationStatement, unnamedArguments, namedArguments);
                        if (parentName == null && unnamedArguments.size() == 1 && namedArguments.isEmpty() && (invokedExpression = applicationStatement.getInvokedExpression()) instanceof GrReferenceExpression) {
                            String name;
                            GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                            GrExpression qualifierExpression = referenceExpression.getQualifierExpression();
                            String qualifierName = "";
                            if (qualifierExpression != null) {
                                qualifierName = qualifierExpression.getText();
                            }
                            if ((name = referenceExpression.getReferenceName()) != null) {
                                String value = (String)unnamedArguments.get(0);
                                GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, qualifierName, null, (Object)invokedExpression, (Object)argumentList, (Object)applicationStatement);
                                }
                            }
                        }
                        for (GradleScanner detector : detectors) {
                            detector.checkMethodCall(context, statementName, parentName, parentParentName, (Map)namedArguments, (List)unnamedArguments, (Object)applicationStatement);
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }

                    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                        GrExpression lvalue;
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)expression, GrClosableBlock.class, (boolean)true);
                        if (block == null && (lvalue = expression.getLValue()) instanceof GrReferenceExpression) {
                            GrReferenceExpression lvalueRef = (GrReferenceExpression)lvalue;
                            GrExpression qualifierExpression = lvalueRef.getQualifierExpression();
                            String qualifierName = "";
                            if (qualifierExpression != null) {
                                qualifierName = qualifierExpression.getText();
                            }
                            String name = lvalueRef.getReferenceName();
                            GrExpression rvalue = expression.getRValue();
                            if (rvalue != null) {
                                String value = rvalue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, qualifierName, null, (Object)lvalue, (Object)rvalue, (Object)expression);
                                }
                            }
                        }
                        super.visitAssignmentExpression(expression);
                    }
                });
            }
        });
    }

    public int getStartOffset(@NotNull GradleContext context, @NotNull Object cookie) {
        int startOffset = super.getStartOffset(context, cookie);
        if (startOffset != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    @NotNull
    public Location createLocation(@NotNull GradleContext context, @NotNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        return Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
    }
}

