/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.view;

import com.intellij.CommonBundle;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.config.Config;
import org.jetbrains.java.generate.config.DuplicationPolicy;
import org.jetbrains.java.generate.config.InsertWhere;
import org.jetbrains.java.generate.config.PolicyOptions;

public class ConfigUI
extends JPanel {
    private final JCheckBox fullyQualifiedName = new JCheckBox(JavaBundle.message((String)"generate.tostring.fully.qualified.class.name", (Object[])new Object[0]));
    private final JCheckBox enableMethods = new JCheckBox(JavaBundle.message((String)"generate.tostring.getters.in.generated.code", (Object[])new Object[0]));
    private final JCheckBox moveCaretToMethod = new JCheckBox(JavaBundle.message((String)"generate.tostring.move.to.generated.checkbox", (Object[])new Object[0]));
    private JRadioButton[] initialValueForReplaceDialog;
    private JRadioButton[] initialValueForNewMethodDialog;
    private final JCheckBox filterConstant = new JCheckBox(JavaBundle.message((String)"generate.tostring.exclude.constant.fields", (Object[])new Object[0]));
    private final JCheckBox filterEnum = new JCheckBox(JavaBundle.message((String)"generate.tostring.exclude.enum.fields", (Object[])new Object[0]));
    private final JCheckBox filterStatic = new JCheckBox(JavaBundle.message((String)"generate.tostring.exclude.static.fields", (Object[])new Object[0]));
    private final JCheckBox filterTransient = new JCheckBox(JavaBundle.message((String)"generate.tostring.exclude..transient", (Object[])new Object[0]));
    private final JCheckBox filterLoggers = new JCheckBox(JavaBundle.message((String)"generate.tostring.exclude.logger", (Object[])new Object[0]));
    private final LanguageTextField filterFieldName;
    private final LanguageTextField filterFieldType;
    private final LanguageTextField filterMethodName;
    private final LanguageTextField filterMethodType;
    private final JComboBox sortElementsComboBox = new JComboBox();
    private final JCheckBox sortElements = new JCheckBox(JavaBundle.message((String)"generate.tostring.sort.checkbox", (Object[])new Object[0]));

    public ConfigUI(Config config, Project project) {
        super(new BorderLayout());
        this.filterFieldName = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, config.getFilterFieldName());
        this.filterFieldType = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, config.getFilterFieldType());
        this.filterMethodName = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, config.getFilterMethodName());
        this.filterMethodType = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, config.getFilterMethodType());
        this.init();
        this.setConfig(config);
    }

    private void init() {
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)this.initSettingPanel(), "West");
        this.add((Component)header, "North");
    }

    private JPanel initSettingPanel() {
        GridBagConstraints constraint = new GridBagConstraints();
        JPanel outer = new JPanel(new GridBagLayout());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"generate.tostring.settings", (Object[])new Object[0])));
        Box innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.fullyQualifiedName);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.enableMethods);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.moveCaretToMethod);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.sortElements);
        this.sortElements.addActionListener(new OnSortElements());
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.sortElementsComboBox);
        panel2.add(innerPanel);
        this.sortElementsComboBox.addItem(JavaBundle.message((String)"generate.tostring.sort.ascending", (Object[])new Object[0]));
        this.sortElementsComboBox.addItem(JavaBundle.message((String)"generate.tostring.sort.descending", (Object[])new Object[0]));
        this.sortElementsComboBox.addItem(JavaBundle.message((String)"generate.tostring.sort.super", (Object[])new Object[0]));
        constraint.gridwidth = 0;
        constraint.fill = 1;
        constraint.gridx = 0;
        constraint.gridy = 0;
        constraint.insets.left = 5;
        constraint.insets.right = 5;
        outer.add((Component)panel2, constraint);
        DuplicationPolicy[] options = PolicyOptions.getConflictOptions();
        this.initialValueForReplaceDialog = new JRadioButton[options.length];
        ButtonGroup selection = new ButtonGroup();
        for (int i = 0; i < options.length; ++i) {
            this.initialValueForReplaceDialog[i] = new JRadioButton(new ConflictResolutionOptionAction(options[i]));
            selection.add(this.initialValueForReplaceDialog[i]);
        }
        panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"generate.tostring.already.exist.border", (Object[])new Object[0])));
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            panel2.add(anInitialValueForReplaceDialog);
        }
        constraint.gridx = 0;
        constraint.gridy = 1;
        outer.add((Component)panel2, constraint);
        InsertWhere[] options2 = PolicyOptions.getNewMethodOptions();
        this.initialValueForNewMethodDialog = new JRadioButton[options2.length];
        ButtonGroup selection2 = new ButtonGroup();
        for (int i = 0; i < options2.length; ++i) {
            this.initialValueForNewMethodDialog[i] = new JRadioButton(new InsertNewMethodOptionAction(options2[i]));
            selection2.add(this.initialValueForNewMethodDialog[i]);
        }
        panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"generate.tostring.insert.border", (Object[])new Object[0])));
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            panel2.add(anInitialValueForNewMethodDialog);
        }
        constraint.gridx = 0;
        constraint.gridy = 2;
        outer.add((Component)panel2, constraint);
        panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)CommonBundle.message((String)"button.exclude", (Object[])new Object[0])));
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterConstant);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterStatic);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterTransient);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterEnum);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterLoggers);
        innerPanel.add(Box.createHorizontalGlue());
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel(JavaBundle.message((String)"generate.tostring.exclude.by.field.name", (Object[])new Object[0])));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add((Component)this.filterFieldName);
        this.filterFieldName.setMinimumSize((Dimension)JBUI.size((int)100, (int)20));
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel(JavaBundle.message((String)"generate.tostring.exclude.by.field.type", (Object[])new Object[0])));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add((Component)this.filterFieldType);
        this.filterFieldType.setMinimumSize((Dimension)JBUI.size((int)100, (int)20));
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel(JavaBundle.message((String)"generate.tostring.exclude.by.name", (Object[])new Object[0])));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add((Component)this.filterMethodName);
        this.filterMethodName.setMinimumSize((Dimension)JBUI.size((int)100, (int)20));
        panel2.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel(JavaBundle.message((String)"generate.tostring.exclude.by.return.type", (Object[])new Object[0])));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add((Component)this.filterMethodType);
        this.filterMethodType.setMinimumSize((Dimension)JBUI.size((int)100, (int)20));
        panel2.add(innerPanel);
        constraint.gridx = 0;
        constraint.gridy = 3;
        outer.add((Component)panel2, constraint);
        return outer;
    }

    public final void setConfig(Config config) {
        this.fullyQualifiedName.setSelected(config.isUseFullyQualifiedName());
        DuplicationPolicy option = config.getReplaceDialogInitialOption();
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            if (!anInitialValueForReplaceDialog.getText().equals(option.toString())) continue;
            anInitialValueForReplaceDialog.setSelected(true);
        }
        InsertWhere option2 = config.getInsertNewMethodInitialOption();
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            if (!anInitialValueForNewMethodDialog.getText().equals(option2.toString())) continue;
            anInitialValueForNewMethodDialog.setSelected(true);
        }
        this.filterConstant.setSelected(config.isFilterConstantField());
        this.filterEnum.setSelected(config.isFilterEnumField());
        this.filterStatic.setSelected(config.isFilterStaticModifier());
        this.filterTransient.setSelected(config.isFilterTransientModifier());
        this.filterLoggers.setSelected(config.isFilterLoggers());
        this.enableMethods.setSelected(config.isEnableMethods());
        this.moveCaretToMethod.setSelected(config.isJumpToMethod());
        int sort = config.getSortElements();
        this.sortElements.setSelected(sort != 0);
        this.sortElementsComboBox.setEnabled(this.sortElements.isSelected());
        if (sort == 0 || sort == 1) {
            this.sortElementsComboBox.setSelectedIndex(0);
        } else if (sort == 2) {
            this.sortElementsComboBox.setSelectedIndex(1);
        } else if (sort == 3) {
            this.sortElementsComboBox.setSelectedIndex(2);
        }
    }

    @Nullable
    private static String emptyToNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public final Config getConfig() {
        Config config = new Config();
        config.setUseFullyQualifiedName(this.fullyQualifiedName.isSelected());
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            if (!anInitialValueForReplaceDialog.isSelected()) continue;
            config.setReplaceDialogInitialOption(((ConflictResolutionOptionAction)anInitialValueForReplaceDialog.getAction()).option);
        }
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            if (!anInitialValueForNewMethodDialog.isSelected()) continue;
            config.setInsertNewMethodInitialOption(((InsertNewMethodOptionAction)anInitialValueForNewMethodDialog.getAction()).option);
        }
        config.setFilterConstantField(this.filterConstant.isSelected());
        config.setFilterEnumField(this.filterEnum.isSelected());
        config.setFilterTransientModifier(this.filterTransient.isSelected());
        config.setFilterLoggers(this.filterLoggers.isSelected());
        config.setFilterStaticModifier(this.filterStatic.isSelected());
        config.setFilterFieldName(ConfigUI.emptyToNull(this.filterFieldName.getText()));
        config.setFilterFieldType(ConfigUI.emptyToNull(this.filterFieldType.getText()));
        config.setFilterMethodName(ConfigUI.emptyToNull(this.filterMethodName.getText()));
        config.setFilterMethodType(ConfigUI.emptyToNull(this.filterMethodType.getText()));
        config.setEnableMethods(this.enableMethods.isSelected());
        config.setJumpToMethod(this.moveCaretToMethod.isSelected());
        if (!this.sortElements.isSelected()) {
            config.setSortElements(0);
        } else {
            config.setSortElements(this.sortElementsComboBox.getSelectedIndex() + 1);
        }
        return config;
    }

    private class OnSortElements
    implements ActionListener {
        private OnSortElements() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigUI.this.sortElementsComboBox.setEnabled(ConfigUI.this.sortElements.isSelected());
        }
    }

    private static class InsertNewMethodOptionAction
    extends AbstractAction {
        public final InsertWhere option;

        InsertNewMethodOptionAction(InsertWhere option) {
            super(option.toString());
            this.option = option;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class ConflictResolutionOptionAction
    extends AbstractAction {
        public final DuplicationPolicy option;

        ConflictResolutionOptionAction(DuplicationPolicy option) {
            super(option.toString());
            this.option = option;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

