/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.InsertAtCaretStrategy;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class InsertAfterEqualsHashCodeStrategy
implements InsertNewMethodStrategy {
    private static final InsertAfterEqualsHashCodeStrategy instance = new InsertAfterEqualsHashCodeStrategy();

    private InsertAfterEqualsHashCodeStrategy() {
    }

    public static InsertAfterEqualsHashCodeStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) {
        PsiMethod methodHashCode = PsiAdapter.findHashCodeMethod(clazz);
        PsiMethod methodEquals = PsiAdapter.findEqualsMethod(clazz);
        PsiMethod method = methodEquals != null && methodHashCode != null ? (methodEquals.getTextOffset() > methodHashCode.getTextOffset() ? methodEquals : methodHashCode) : (methodHashCode != null ? methodHashCode : methodEquals);
        newMethod = method != null ? (PsiMethod)clazz.addAfter((PsiElement)newMethod, (PsiElement)method) : InsertAtCaretStrategy.getInstance().insertNewMethod(clazz, newMethod, editor);
        return newMethod;
    }

    public String toString() {
        return "After equals/hashCode";
    }
}

