/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.config.Config;
import org.jetbrains.java.generate.config.ConflictResolutionPolicy;
import org.jetbrains.java.generate.config.DuplicatePolicy;
import org.jetbrains.java.generate.config.DuplicationPolicy;
import org.jetbrains.java.generate.config.InsertAfterEqualsHashCodeStrategy;
import org.jetbrains.java.generate.config.InsertAtCaretStrategy;
import org.jetbrains.java.generate.config.InsertLastStrategy;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;
import org.jetbrains.java.generate.config.InsertWhere;
import org.jetbrains.java.generate.config.ReplacePolicy;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.psi.PsiAdapter;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.view.MethodExistsDialog;

public class GenerateToStringWorker {
    private static final Logger logger = Logger.getInstance(GenerateToStringWorker.class);
    private final Editor editor;
    private final PsiClass clazz;
    private final Config config;
    private final boolean hasOverrideAnnotation;

    public GenerateToStringWorker(PsiClass clazz, Editor editor, boolean insertAtOverride) {
        this.clazz = clazz;
        this.editor = editor;
        this.config = GenerateToStringContext.getConfig();
        this.hasOverrideAnnotation = insertAtOverride;
    }

    @Nullable
    private PsiMethod createToStringMethod(Collection<PsiMember> selectedMembers, ConflictResolutionPolicy policy, Map<String, String> params, TemplateResource template) throws IncorrectOperationException, GenerateCodeException {
        PsiMethod newMethod = this.getMethodPrototype(selectedMembers, params, template);
        if (newMethod == null) {
            return null;
        }
        CodeStyleManager.getInstance((Project)this.clazz.getProject()).reformat((PsiElement)newMethod);
        PsiMethod existingMethod = this.clazz.findMethodBySignature(newMethod, false);
        PsiMethod toStringMethod = policy.applyMethod(this.clazz, existingMethod, newMethod, this.editor);
        if (toStringMethod == null) {
            return null;
        }
        if (this.hasOverrideAnnotation) {
            toStringMethod.getModifierList().addAnnotation("java.lang.Override");
        }
        String existingJavaDoc = params.get("existingJavaDoc");
        String newJavaDoc = template.getJavaDoc();
        if (existingJavaDoc != null || newJavaDoc != null) {
            newJavaDoc = GenerationUtil.velocityGenerateCode(this.clazz, selectedMembers, params, newJavaDoc, this.config.getSortElements(), this.config.isUseFullyQualifiedName());
            if (logger.isDebugEnabled()) {
                logger.debug("JavaDoc body generated from Velocity:\n" + newJavaDoc);
            }
            GenerationUtil.applyJavaDoc(toStringMethod, existingJavaDoc, newJavaDoc);
        }
        return toStringMethod;
    }

    private PsiMethod getMethodPrototype(Collection<PsiMember> selectedMembers, Map<String, String> params, TemplateResource template) {
        String evaluatedText = GenerationUtil.velocityGenerateCode(this.clazz, selectedMembers, params, template.getTemplate(), this.config.getSortElements(), this.config.isUseFullyQualifiedName());
        JVMElementFactory topLevelFactory = JVMElementFactories.getFactory((Language)this.clazz.getLanguage(), (Project)this.clazz.getProject());
        if (topLevelFactory == null) {
            return null;
        }
        try {
            return topLevelFactory.createMethodFromText(evaluatedText, (PsiElement)this.clazz);
        }
        catch (IncorrectOperationException e) {
            logger.info((Throwable)e);
            HintManager.getInstance().showErrorHint(this.editor, "'toString()' method could not be created from template '" + template.getFileName() + '\'');
            return null;
        }
    }

    public void execute(Collection<PsiMember> members, TemplateResource template, ConflictResolutionPolicy resolutionPolicy) throws IncorrectOperationException, GenerateCodeException {
        resolutionPolicy.setNewMethodStrategy(GenerateToStringWorker.getStrategy(this.config.getInsertNewMethodInitialOption()));
        HashMap<String, String> params = new HashMap<String, String>();
        this.beforeCreateToStringMethod(params, template);
        PsiMethod method = this.createToStringMethod(members, resolutionPolicy, params, template);
        if (method != null) {
            this.afterCreateToStringMethod(method, params, template);
        }
    }

    private static InsertNewMethodStrategy getStrategy(InsertWhere option) {
        switch (option) {
            case AFTER_EQUALS_AND_HASHCODE: {
                return InsertAfterEqualsHashCodeStrategy.getInstance();
            }
            case AT_CARET: {
                return InsertAtCaretStrategy.getInstance();
            }
            case AT_THE_END_OF_A_CLASS: {
                return InsertLastStrategy.getInstance();
            }
        }
        return InsertLastStrategy.getInstance();
    }

    protected ConflictResolutionPolicy exitsMethodDialog(TemplateResource template) {
        DuplicationPolicy dupPolicy = this.config.getReplaceDialogInitialOption();
        if (dupPolicy == DuplicationPolicy.ASK) {
            PsiMethod existingMethod;
            PsiMethod targetMethod = this.getMethodPrototype(Collections.emptyList(), Collections.emptyMap(), template);
            PsiMethod psiMethod = existingMethod = targetMethod != null ? this.clazz.findMethodBySignature(targetMethod, false) : null;
            if (existingMethod != null) {
                return MethodExistsDialog.showDialog(targetMethod.getName());
            }
        } else if (dupPolicy == DuplicationPolicy.REPLACE) {
            return ReplacePolicy.getInstance();
        }
        return DuplicatePolicy.getInstance();
    }

    private void beforeCreateToStringMethod(Map<String, String> params, TemplateResource template) {
        PsiDocComment doc;
        PsiMethod targetMethod = this.getMethodPrototype(Collections.emptyList(), Collections.emptyMap(), template);
        if (targetMethod == null) {
            return;
        }
        PsiMethod existingMethod = this.clazz.findMethodBySignature(targetMethod, false);
        if (existingMethod != null && existingMethod.getDocComment() != null && (doc = existingMethod.getDocComment()) != null) {
            params.put("existingJavaDoc", doc.getText());
        }
    }

    private void afterCreateToStringMethod(PsiMethod method, Map<String, String> params, TemplateResource template) {
        PsiFile containingFile = this.clazz.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            if (params.get("autoImportPackages") != null) {
                GenerateToStringWorker.autoImportPackages(javaFile, params.get("autoImportPackages"));
            }
        }
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.clazz.getProject()).shortenClassReferences((PsiElement)method);
        if (!this.config.isJumpToMethod() || this.editor == null) {
            return;
        }
        int offset = method.getTextOffset();
        if (offset <= 2) {
            return;
        }
        VisualPosition vp = this.editor.offsetToVisualPosition(offset);
        if (logger.isDebugEnabled()) {
            logger.debug("Moving/Scrolling caret to " + vp + " (offset=" + offset + ")");
        }
        this.editor.getCaretModel().moveToVisualPosition(vp);
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
    }

    private static void autoImportPackages(PsiJavaFile psiJavaFile, String packageNames) throws IncorrectOperationException {
        StringTokenizer tok = new StringTokenizer(packageNames, ",");
        while (tok.hasMoreTokens()) {
            String packageName = tok.nextToken().trim();
            if (logger.isDebugEnabled()) {
                logger.debug("Auto importing package: " + packageName);
            }
            PsiAdapter.addImportStatement(psiJavaFile, packageName);
        }
    }
}

