/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiSelectionSearcher {
    private PsiSelectionSearcher() {
    }

    @NotNull
    public static <T extends PsiElement> List<T> searchElementsInSelection(Editor editor, Project project, Class<T> filter, boolean searchChildrenOfFound) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return Collections.emptyList();
        }
        UnfairTextRange selection = new UnfairTextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null || file instanceof PsiCompiledElement) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor((TextRange)selection, filter, results, searchChildrenOfFound){
            final /* synthetic */ TextRange val$selection;
            final /* synthetic */ Class val$filter;
            final /* synthetic */ List val$results;
            final /* synthetic */ boolean val$searchChildrenOfFound;
            {
                this.val$selection = textRange;
                this.val$filter = clazz;
                this.val$results = list;
                this.val$searchChildrenOfFound = bl;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (!this.val$selection.intersects(element.getTextRange())) {
                    return;
                }
                if (this.val$filter.isAssignableFrom(element.getClass())) {
                    this.val$results.add(element);
                    if (!this.val$searchChildrenOfFound) {
                        return;
                    }
                }
                super.visitElement(element);
            }
        };
        file.accept((PsiElementVisitor)visitor2);
        return results;
    }
}

