/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplacePostfixExpressionWithOperatorAssignmentPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplacePostfixExpressionWithAssignmentIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiJavaToken sign = postfixExpression.getOperationSign();
        String signText = sign.getText();
        String replacementText = "=";
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{signText, "="});
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ReplacePostfixExpressionWithOperatorAssignmentPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand2 = postfixExpression.getOperand();
        CommentTracker commentTracker = new CommentTracker();
        String operandText = commentTracker.text((PsiElement)operand2);
        IElementType tokenType = postfixExpression.getOperationTokenType();
        if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, operandText + '=' + operandText + "+1", commentTracker);
        } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, operandText + '=' + operandText + "-1", commentTracker);
        }
    }
}

