/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.util.text.CharArrayUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CStyleCommentPredicate;
import org.jetbrains.annotations.NotNull;

public class ChangeToEndOfLineCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new CStyleCommentPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiComment oldComment = (PsiComment)element;
        PsiElement parent = oldComment.getParent();
        assert (parent != null);
        String commentText = oldComment.getText();
        String text2 = commentText.substring(2, commentText.length() - 2);
        String[] lines = text2.split("\n");
        int tabSize = ChangeToEndOfLineCommentIntention.getTabSize((PsiElement)oldComment);
        int textColumn = ChangeToEndOfLineCommentIntention.getTextStartColumn(text2, tabSize);
        int commentColumn = ChangeToEndOfLineCommentIntention.getCommentStartColumn(oldComment, tabSize);
        int column = textColumn >= 0 ? textColumn : commentColumn - textColumn + 1;
        ChangeToEndOfLineCommentIntention.trimLinesWithAlignment(lines, tabSize, column);
        Project project = oldComment.getProject();
        PsiElement ws = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n ");
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        int last = lines[lines.length - 1].trim().isEmpty() ? lines.length - 2 : lines.length - 1;
        int first = lines[0].trim().isEmpty() ? 1 : 0;
        for (int i = last; i > first; --i) {
            parent.addAfter((PsiElement)factory.createCommentFromText("// " + lines[i], parent), (PsiElement)oldComment);
            if (commentColumn <= 0) continue;
            parent.addAfter(ws, (PsiElement)oldComment);
        }
        String firstLine = (textColumn >= 0 ? "// " : "//") + (first >= lines.length ? "" : lines[first]);
        oldComment.replace((PsiElement)factory.createCommentFromText(firstLine, parent));
    }

    private static int getTabSize(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file == null ? 1 : Math.max(1, CodeStyle.getIndentOptions((PsiFile)file).TAB_SIZE);
    }

    private static int getTextStartColumn(@NotNull String text2, int tabSize) {
        int column = 0;
        boolean newlineSeen = false;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                newlineSeen = true;
                continue;
            }
            if (c != ' ' && c != '\t') break;
            if (column < 0) continue;
            column = ChangeToEndOfLineCommentIntention.nextColumn(column, c, tabSize);
        }
        return newlineSeen ? column : -column - 1;
    }

    private static int getCommentStartColumn(@NotNull PsiComment element, int tabSize) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return 0;
        }
        String text2 = file.getText();
        if (text2 == null) {
            return 0;
        }
        int elementOffset = element.getTextRange().getStartOffset();
        int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)text2, (int)(elementOffset - 1), (String)"\n") + 1;
        int column = 0;
        for (int i = lineStart; i < elementOffset; ++i) {
            column = ChangeToEndOfLineCommentIntention.nextColumn(column, text2.charAt(i), tabSize);
        }
        return column;
    }

    private static void trimLinesWithAlignment(String @NotNull [] lines, int tabSize, int firstLineStartColumn) {
        if (lines.length == 1) {
            lines[0] = StringUtil.trimTrailing((String)lines[0]);
        } else {
            int column;
            String line;
            int i;
            int minIndent = firstLineStartColumn;
            block0: for (i = 1; i < lines.length; ++i) {
                line = lines[i];
                column = 0;
                for (int j = 0; j < line.length(); ++j) {
                    char c = line.charAt(j);
                    if (" \t".indexOf(c) == -1) {
                        if (column >= minIndent) continue block0;
                        minIndent = column;
                        continue block0;
                    }
                    if ((column = ChangeToEndOfLineCommentIntention.nextColumn(column, c, tabSize)) >= minIndent) continue block0;
                }
            }
            for (i = 1; i < lines.length; ++i) {
                int trimOffset;
                line = lines[i];
                column = 0;
                for (trimOffset = 0; trimOffset < line.length() && (column = ChangeToEndOfLineCommentIntention.nextColumn(column, line.charAt(trimOffset), tabSize)) <= minIndent; ++trimOffset) {
                }
                lines[i] = StringUtil.trimTrailing((String)line.substring(trimOffset));
            }
        }
    }

    private static int nextColumn(int currentColumn, char c, int tabSize) {
        return c == '\t' ? (currentColumn / tabSize + 1) * tabSize : currentColumn + 1;
    }
}

