/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class CharToStringPredicate
implements PsiElementPredicate {
    CharToStringPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression2 = (PsiLiteralExpression)element;
        PsiType type2 = expression2.getType();
        if (!PsiType.CHAR.equals((Object)type2)) {
            return false;
        }
        String charLiteral = element.getText();
        if (charLiteral.length() < 2) {
            return false;
        }
        String charText = charLiteral.substring(1, charLiteral.length() - 1);
        if (StringUtil.unescapeStringCharacters((String)charText).length() != 1) {
            return false;
        }
        return CharToStringPredicate.isInConcatenationContext((PsiExpression)expression2);
    }

    static boolean isInConcatenationContext(PsiExpression element) {
        if (ExpressionUtils.isStringConcatenationOperand(element)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentExpression = (PsiAssignmentExpression)parent;
            IElementType tokenType = parentExpression.getOperationTokenType();
            if (!JavaTokenType.PLUSEQ.equals(tokenType)) {
                return false;
            }
            PsiType parentType = parentExpression.getType();
            if (parentType == null) {
                return false;
            }
            String parentTypeText = parentType.getCanonicalText();
            return "java.lang.String".equals(parentTypeText);
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            PsiType type2 = qualifierExpression2 == null ? methodExpression.getType() : qualifierExpression2.getType();
            if (type2 == null) {
                return false;
            }
            String className2 = type2.getCanonicalText();
            if ("java.lang.StringBuffer".equals(className2) || "java.lang.StringBuilder".equals(className2)) {
                String methodName = methodExpression.getReferenceName();
                if (!"append".equals(methodName) && !"insert".equals(methodName)) {
                    return false;
                }
                PsiElement method = methodExpression.resolve();
                return method != null;
            }
            if ("java.lang.String".equals(className2)) {
                String methodName = methodExpression.getReferenceName();
                if (!("indexOf".equals(methodName) || "lastIndexOf".equals(methodName) || "replace".equals(methodName))) {
                    return false;
                }
                PsiElement method = methodExpression.resolve();
                return method != null;
            }
        }
        return false;
    }
}

