/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class NegateConditionalIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        PsiExpression condition2 = conditionalExpression.getCondition();
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        CommentTracker tracker = new CommentTracker();
        String newExpression = tracker.text((PsiElement)condition2) + '?' + BoolUtils.getNegatedExpressionText(thenExpression2, tracker) + ':' + BoolUtils.getNegatedExpressionText(elseExpression2, tracker);
        NegateConditionalIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)conditionalExpression, tracker);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new BooleanConditionalExpressionPredicate();
    }

    private static class BooleanConditionalExpressionPredicate
    implements PsiElementPredicate {
        private BooleanConditionalExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            if (!(element instanceof PsiConditionalExpression)) {
                return false;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiType type2 = conditionalExpression.getType();
            return PsiType.BOOLEAN.equals((Object)type2);
        }
    }
}

