/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.base;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
extends BaseElementAtCaretIntentionAction {
    @FileModifier.SafeFieldForPreview
    private final NotNullLazyValue<PsiElementPredicate> myPredicate = AtomicNotNullLazyValue.createValue(() -> this.getElementPredicate());

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement matchingElement = this.findMatchingElement(element, editor);
        if (matchingElement == null) {
            return;
        }
        this.processIntention(editor, matchingElement);
    }

    protected abstract void processIntention(@NotNull PsiElement var1);

    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        this.processIntention(element);
    }

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull PsiExpression expression2, CommentTracker tracker) {
        PsiExpression insertedElement;
        String expString;
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression expressionToReplace = expression2;
        if (BoolUtils.isNegated(expression2)) {
            expressionToReplace = BoolUtils.findNegation(expressionToReplace);
            expString = newExpression;
        } else {
            PsiElement parent = expressionToReplace.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expressionToReplace = (PsiExpression)parent;
                parent = parent.getParent();
            }
            expString = "!(" + newExpression + ')';
        }
        assert (expressionToReplace != null);
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression2);
        if (newCall instanceof PsiPolyadicExpression && (insertedElement = ExpressionUtils.replacePolyadicWithParent(expressionToReplace, newCall)) != null) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)insertedElement);
            return;
        }
        insertedElement = tracker.replaceAndRestoreComments((PsiElement)expressionToReplace, (PsiElement)newCall);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)insertedElement);
    }

    @Nullable
    PsiElement findMatchingElement(@Nullable PsiElement element, Editor editor) {
        if (element == null || !JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return null;
        }
        PsiElementPredicate predicate = (PsiElementPredicate)this.myPredicate.getValue();
        while (element != null && JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            if (predicate instanceof PsiElementEditorPredicate ? ((PsiElementEditorPredicate)predicate).satisfiedBy(element, editor) : predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return this.findMatchingElement(element, editor) != null;
    }

    private String getPrefix() {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name2 = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name2.length() + 10);
        buffer.append(Character.toLowerCase(name2.charAt(0)));
        for (int i = 1; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getText() {
        return IntentionPowerPackBundle.message(this.getPrefix() + ".name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IntentionPowerPackBundle.defaultableMessage(this.getPrefix() + ".family.name", new Object[0]);
    }
}

