/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySuperQualifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreClarification;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.super.qualifier.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"inspection.unnecessary.super.qualifier.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "ignoreClarification");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySuperQualifierFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperQualifierVisitor(this.ignoreClarification);
    }

    private static class UnnecessarySuperQualifierVisitor
    extends BaseInspectionVisitor {
        private final boolean myIgnoreClarification;

        UnnecessarySuperQualifierVisitor(boolean ignoreClarification) {
            this.myIgnoreClarification = ignoreClarification;
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = referenceExpression.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiClass containingClass;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(methodCallExpression)) {
                    return;
                }
                if (this.myIgnoreClarification && (containingClass = ClassUtils.getContainingClass((PsiElement)expression2)) != null) {
                    PsiExpression copyCall;
                    PsiMethod method;
                    PsiElement classParent = containingClass.getParent();
                    String referenceName = methodCallExpression.getMethodExpression().getReferenceName();
                    if (referenceName != null && (method = ((PsiMethodCallExpression)(copyCall = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(referenceName + methodCallExpression.getArgumentList().getText(), classParent))).resolveMethod()) != null && method != referenceExpression.resolve()) {
                        return;
                    }
                }
            } else {
                PsiClass containingClass;
                if (!UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(referenceExpression)) {
                    return;
                }
                if (this.myIgnoreClarification && (containingClass = ClassUtils.getContainingClass((PsiElement)expression2)) != null) {
                    PsiVariable variable;
                    PsiElement classParent = containingClass.getParent();
                    String referenceText = referenceExpression.getReferenceName();
                    if (referenceText != null && (variable = PsiResolveHelper.SERVICE.getInstance((Project)expression2.getProject()).resolveAccessibleReferencedVariable(referenceText, classParent)) != null && variable != referenceExpression.resolve()) {
                        return;
                    }
                }
            }
            this.registerError((PsiElement)expression2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private static boolean hasUnnecessarySuperQualifier(PsiReferenceExpression referenceExpression) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            if (parentClass == null) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField superField = (PsiField)target;
            PsiReferenceExpression copy = (PsiReferenceExpression)referenceExpression.copy();
            PsiElement qualifier = copy.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.advancedResolve(false);
            return resolveResult.isValidResult() && superField == resolveResult.getElement();
        }

        private static boolean hasUnnecessarySuperQualifier(PsiMethodCallExpression methodCallExpression) {
            PsiMethod superMethod = methodCallExpression.resolveMethod();
            if (superMethod == null) {
                return false;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (aClass != null && MethodUtils.isOverriddenInHierarchy(superMethod, aClass)) {
                return false;
            }
            PsiMethodCallExpression copy = (PsiMethodCallExpression)methodCallExpression.copy();
            PsiReferenceExpression methodExpression = copy.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            return resolveResult.isValidResult() && superMethod.getManager().areElementsEquivalent((PsiElement)superMethod, element);
        }
    }

    private static class UnnecessarySuperQualifierFix
    extends InspectionGadgetsFix {
        private UnnecessarySuperQualifierFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.super.qualifier.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            element.delete();
        }
    }
}

