/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConstructorInspection
extends BaseInspection {
    public boolean ignoreAnnotations = false;

    @NotNull
    public String getID() {
        return "RedundantNoArgConstructor";
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.constructor.annotation.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAnnotations");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConstructorFix();
    }

    private class UnnecessaryConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiModifierList modifierList;
            PsiAnnotation[] annotations;
            String modifier;
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 1) {
                return;
            }
            PsiMethod constructor = constructors[0];
            if (!constructor.isPhysical() || constructor.getNameIdentifier() == null) {
                return;
            }
            if (!aClass.isEnum() && !constructor.hasModifierProperty(modifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()))) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            if (UnnecessaryConstructorInspection.this.ignoreAnnotations && (annotations = (modifierList = constructor.getModifierList()).getAnnotations()).length > 0) {
                return;
            }
            PsiReferenceList throwsList = constructor.getThrowsList();
            PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
            if (elements.length != 0) {
                return;
            }
            PsiCodeBlock body2 = constructor.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body2) || this.isSuperConstructorInvocationWithoutArguments(ControlFlowUtils.getOnlyStatementInBlock(body2))) {
                this.registerMethodError(constructor, new Object[0]);
            }
        }

        private boolean isSuperConstructorInvocationWithoutArguments(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return "super".equals(methodExpression.getReferenceName());
        }
    }

    private static class UnnecessaryConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessaryConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.constructor.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement constructor = nameIdentifier.getParent();
            assert (constructor != null);
            UnnecessaryConstructorFix.deleteElement(constructor);
        }
    }
}

