/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryBlockStatementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSwitchBranches = false;

    @NotNull
    public String getID() {
        return "UnnecessaryCodeBlock";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.block.statement.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.branches.of.switch.statements", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchBranches");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBlockStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBlockFix();
    }

    private class UnnecessaryBlockStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBlockStatementVisitor() {
        }

        public void visitBlockStatement(PsiBlockStatement blockStatement) {
            PsiElement prevStatement;
            super.visitBlockStatement(blockStatement);
            if (UnnecessaryBlockStatementInspection.this.ignoreSwitchBranches && (prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)blockStatement)) instanceof PsiSwitchLabelStatement) {
                return;
            }
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiJavaToken brace = codeBlock.getLBrace();
            if (brace == null) {
                return;
            }
            PsiCodeBlock parentBlock = (PsiCodeBlock)parent;
            if (parentBlock.getStatementCount() > 1 && BlockUtils.containsConflictingDeclarations(codeBlock, parentBlock)) {
                return;
            }
            this.registerError((PsiElement)brace, new Object[0]);
        }
    }

    private static class UnnecessaryBlockFix
    extends InspectionGadgetsFix {
        private UnnecessaryBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.code.block.unwrap.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement leftBrace = descriptor.getPsiElement();
            PsiElement parent = leftBrace.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)parent;
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            PsiBlockStatement blockStatement = (PsiBlockStatement)block.getParent();
            if (firstBodyElement != null && lastBodyElement != null) {
                PsiElement element = blockStatement.getParent();
                element.addRangeBefore(firstBodyElement, lastBodyElement, (PsiElement)blockStatement);
            }
            blockStatement.delete();
        }
    }
}

