/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.IfConditionalModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean DONT_WARN_ON_TERNARY = true;
    public boolean DONT_WARN_ON_CHAINED_ID = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.option.dont.warn.on.ternary", new Object[0]), "DONT_WARN_ON_TERNARY");
        panel2.addCheckbox(InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), "DONT_WARN_ON_CHAINED_ID");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                boolean infoLevel;
                IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
                if (model == null) {
                    return;
                }
                ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
                if (generator == null) {
                    return;
                }
                String operator2 = generator.getTokenType();
                if (operator2.isEmpty()) {
                    return;
                }
                boolean bl = infoLevel = operator2.equals("?:") && (SimplifiableIfStatementInspection.this.DONT_WARN_ON_TERNARY || model.getThenExpression() instanceof PsiConditionalExpression || model.getElseExpression() instanceof PsiConditionalExpression) || SimplifiableIfStatementInspection.this.DONT_WARN_ON_CHAINED_ID && ControlFlowUtils.isElseIf(ifStatement);
                if (!isOnTheFly && infoLevel) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.message", operator2), infoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new SimplifiableIfStatementFix(operator2)});
            }
        };
    }

    public static void tryJoinDeclaration(PsiElement result) {
        if (!(result instanceof PsiExpressionStatement)) {
            return;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)result).getExpression(), PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)result), PsiDeclarationStatement.class);
        if (declaration2 == null) {
            return;
        }
        PsiElement[] elements = declaration2.getDeclaredElements();
        if (elements.length != 1) {
            return;
        }
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
        if (var == null || var.getInitializer() != null || !ref.isReferenceTo((PsiElement)var)) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        var.setInitializer(ct.markUnchanged(assignment.getRExpression()));
        ct.deleteAndRestoreComments(result);
    }

    private static class SimplifiableIfStatementFix
    implements LocalQuickFix {
        private final String myOperator;

        SimplifiableIfStatementFix(String operator2) {
            this.myOperator = operator2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.name", this.myOperator);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String conditional = generator.generate(commentTracker);
            commentTracker.replace((PsiElement)model.getThenExpression(), conditional);
            if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)model.getElseBranch(), (boolean)true)) {
                commentTracker.delete((PsiElement)model.getElseBranch());
            }
            PsiElement result = commentTracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)model.getThenBranch());
            SimplifiableIfStatementInspection.tryJoinDeclaration(result);
        }
    }
}

