/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LiteralAsArgToStringEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        return InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.problem.descriptor", methodName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LiteralAsArgToEqualsVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String methodName = (String)infos[0];
        return new SwapEqualsFix(methodName);
    }

    private static class LiteralAsArgToEqualsVisitor
    extends BaseInspectionVisitor {
        private LiteralAsArgToEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return;
            }
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!(PsiUtil.skipParenthesizedExprDown((PsiExpression)argument) instanceof PsiLiteralExpression)) {
                return;
            }
            if (!TypeUtils.isJavaLangString(argument.getType())) {
                return;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiLiteralExpression) {
                return;
            }
            if (!TypeUtils.isJavaLangString(qualifier.getType())) {
                return;
            }
            this.registerError((PsiElement)argument, methodName);
        }
    }

    private static class SwapEqualsFix
    extends InspectionGadgetsFix {
        private final String myMethodName;

        SwapEqualsFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.flip.quickfix", this.myMethodName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("swap.equals.fix.family.name", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression argument = (PsiExpression)descriptor.getPsiElement();
            PsiElement argumentList = PsiUtil.skipParenthesizedExprUp((PsiElement)argument.getParent());
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)argumentList.getParent();
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
            PsiExpression strippedArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument);
            if (strippedArgument == null || qualifier == null || strippedQualifier == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.grabComments((PsiElement)qualifier);
            tracker.markUnchanged(strippedQualifier);
            tracker.grabComments((PsiElement)argument);
            tracker.markUnchanged(strippedArgument);
            PsiElement newArgument = strippedQualifier.copy();
            methodExpression.setQualifierExpression(strippedArgument);
            argument.replace(newArgument);
            tracker.insertCommentsBefore((PsiElement)expression2);
        }
    }
}

