/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsCalledOnEnumConstantInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("equals.called.on.enum.constant.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        boolean negated = (Boolean)infos[1];
        return EqualsToEqualityFix.buildFix(methodCallExpression, negated);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsCalledOnEnumValueVisitor();
    }

    private static class EqualsCalledOnEnumValueVisitor
    extends BaseInspectionVisitor {
        private EqualsCalledOnEnumValueVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            EqualityCheck check = EqualityCheck.from((PsiExpression)expression2);
            if (check == null) {
                return;
            }
            PsiExpression left = check.getLeft();
            if (!TypeUtils.expressionHasTypeOrSubtype(left, "java.lang.Enum")) {
                return;
            }
            PsiExpression right = check.getRight();
            PsiType comparedTypeErasure = TypeConversionUtil.erasure((PsiType)left.getType());
            PsiType comparisonTypeErasure = TypeConversionUtil.erasure((PsiType)right.getType());
            if (comparedTypeErasure == null || comparisonTypeErasure == null || !TypeConversionUtil.areTypesConvertible((PsiType)comparedTypeErasure, (PsiType)comparisonTypeErasure)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            boolean negated = parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
            this.registerMethodCallError(expression2, expression2, negated);
        }
    }
}

