/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstantExpressionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_RESULT_LENGTH_TO_DISPLAY = 50;
    private static final int MAX_EXPRESSION_LENGTH = 200;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitUnaryExpression(PsiUnaryExpression expression2) {
                this.handle((PsiExpression)expression2);
            }

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                this.handle((PsiExpression)expression2);
            }

            void handle(PsiExpression expression2) {
                if (expression2.getTextLength() > 200) {
                    return;
                }
                if (expression2.getType() == null) {
                    return;
                }
                if (!PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (parent instanceof PsiExpression && PsiUtil.isConstantExpression((PsiExpression)((PsiExpression)parent))) {
                    return;
                }
                try {
                    String valueText;
                    Object value2 = ExpressionUtils.computeConstantExpression(expression2, true);
                    if (value2 != null && !expression2.textMatches((CharSequence)(valueText = ConstantExpressionInspection.getValueText(value2)))) {
                        String message2 = valueText.length() > 50 ? InspectionGadgetsBundle.message("inspection.constant.expression.display.name", new Object[0]) : InspectionGadgetsBundle.message("inspection.constant.expression.message", valueText);
                        holder.registerProblem((PsiElement)expression2, message2, new LocalQuickFix[]{new ComputeConstantValueFix(expression2, valueText)});
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
            }
        };
    }

    private static String getValueText(Object value2) {
        String newExpression;
        if (value2 instanceof String) {
            String string = (String)value2;
            newExpression = '\"' + StringUtil.escapeStringCharacters((String)string) + '\"';
        } else {
            double v;
            newExpression = value2 instanceof Character ? '\'' + StringUtil.escapeStringCharacters((String)value2.toString()) + '\'' : (value2 instanceof Long ? value2.toString() + 'L' : (value2 instanceof Double ? (Double.isNaN(v = ((Double)value2).doubleValue()) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v))) : (value2 instanceof Float ? (Float.isNaN(v = ((Float)value2).floatValue()) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + 'f')) : (value2 == null ? "null" : String.valueOf(value2)))));
        }
        return newExpression;
    }

    private static class ComputeConstantValueFix
    implements LocalQuickFix {
        private final String myText;
        private final String myValueText;

        ComputeConstantValueFix(PsiExpression expression2, String valueText) {
            this.myText = PsiExpressionTrimRenderer.render((PsiExpression)expression2);
            this.myValueText = valueText;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myValueText.length() > 50) {
                return InspectionGadgetsBundle.message("inspection.constant.expression.fix.name", this.myText);
            }
            return InspectionGadgetsBundle.message("inspection.constant.expression.fix.name.with.value", this.myText, this.myValueText);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.constant.expression.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)descriptor.getStartElement();
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            String newExpression = ConstantExpressionInspection.getValueText(value2);
            PsiReplacementUtil.replaceExpression(expression2, newExpression, new CommentTracker());
        }
    }
}

