/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ExternalizableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ExternalizableClassWithSerializationMethods";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (hasReadObject && hasWriteObject) {
            return InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.both", new Object[0]);
        }
        if (hasWriteObject) {
            return InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.write", new Object[0]);
        }
        return InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.read", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExternalizableDefinesSerializationMethodsVisitor();
    }

    private static class ExternalizableDefinesSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private ExternalizableDefinesSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isExternalizable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }
    }
}

