/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ClassLoaderInstantiationInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.loader.instantiation.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassLoaderInstantiationVisitor();
    }

    private static class ClassLoaderInstantiationVisitor
    extends BaseInspectionVisitor {
        private ClassLoaderInstantiationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.lang.ClassLoader")) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

