/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor2 = new VariableAssignedFromVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor2 = new VariablePassedAsArgumentVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, Processor<? super PsiCall> callProcessor) {
        return VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, false, callProcessor);
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern, Processor<? super PsiCall> callProcessor) {
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor2 = new VariablePassedAsArgumentExcludedVisitor(variable, builderPattern, callProcessor);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor2 = new VariableUsedInArrayInitializerVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable) {
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("private")) {
                PsiClass aClass = PsiUtil.getTopLevelClass((PsiElement)variable);
                return VariableAccessUtils.variableIsAssigned(variable, (PsiElement)aClass);
            }
            return DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)variable, false) || ReferencesSearch.search((PsiElement)variable).anyMatch(reference -> {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiExpression.class);
                return expression2 != null && PsiUtil.isAccessedForWriting((PsiExpression)expression2);
            });
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiLambdaExpression.class, PsiCatchSection.class, PsiForStatement.class, PsiForeachStatement.class});
        return VariableAccessUtils.variableIsAssigned(variable, context);
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable, true);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable, recurseIntoClasses);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        return VariableAccessUtils.variableIsReturned(variable, context, false);
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern) {
        if (context == null) {
            return false;
        }
        VariableReturnedVisitor visitor2 = new VariableReturnedVisitor(variable, builderPattern);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableValueUsedVisitor visitor2 = new VariableValueUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor2 = new ArrayContentsAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor2 = new VariableUsedInInnerClassVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        return VariableAccessUtils.mayEvaluateToVariable(expression2, variable, false);
    }

    static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable, boolean builderPattern) {
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression thenExpression2 = conditional.getThenExpression();
            PsiExpression elseExpression2 = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression2, variable, builderPattern) || VariableAccessUtils.mayEvaluateToVariable(elseExpression2, variable, builderPattern);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type2 = variable.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count;
            }
            return count != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable, builderPattern);
        }
        if (builderPattern && expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            PsiType variableType = variable.getType();
            if (!variableType.equals(returnType)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return VariableAccessUtils.mayEvaluateToVariable(qualifier, variable, true);
        }
        return ExpressionUtils.isReferenceTo(expression2, variable);
    }

    public static List<PsiReferenceExpression> getVariableReferences(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (context == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiReferenceExpression> result = new ArrayList<PsiReferenceExpression>();
        PsiTreeUtil.processElements((PsiElement)context, e -> {
            if (e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).isReferenceTo((PsiElement)variable)) {
                result.add((PsiReferenceExpression)e);
            }
            return true;
        });
        return result;
    }

    @Contract(value="_, null -> false")
    public static boolean variableIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        return context != null && VariableUsedVisitor.isVariableUsedIn(variable, context);
    }

    public static boolean variableIsDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, false);
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, true);
    }

    private static boolean variableIsIncrementedOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement, boolean incremented) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression2 = expressionStatement.getExpression();
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression2;
            IElementType tokenType = unaryExpression.getOperationTokenType();
            if (!tokenType.equals(incremented ? JavaTokenType.PLUSPLUS : JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand2 = unaryExpression.getOperand();
            return ExpressionUtils.isReferenceTo(operand2, variable);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!ExpressionUtils.isReferenceTo(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (binaryTokenType != (incremented ? JavaTokenType.PLUS : JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand)) {
                    return ExpressionUtils.isReferenceTo(rOperand, variable);
                }
                if (ExpressionUtils.isOne(rOperand)) {
                    return ExpressionUtils.isReferenceTo(lOperand, variable);
                }
            } else if (tokenType == (incremented ? JavaTokenType.PLUSEQ : JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable, context, (PsiElement)referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children;
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    public static Set<PsiVariable> collectUsedVariables(PsiElement context) {
        if (context == null) {
            return Collections.emptySet();
        }
        VariableCollectingVisitor visitor2 = new VariableCollectingVisitor();
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.getUsedVariables();
    }

    public static boolean isAnyVariableAssigned(@NotNull Collection<? extends PsiVariable> variables, @Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variables, true);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean isLocalVariableCopy(@NotNull PsiLocalVariable variable) {
        return VariableAccessUtils.isLocalVariableCopy(variable, PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()));
    }

    public static boolean isLocalVariableCopy(@NotNull PsiLocalVariable variable, @Nullable PsiExpression expression2) {
        PsiExpression operand2;
        if (expression2 instanceof PsiTypeCastExpression && (operand2 = ((PsiTypeCastExpression)expression2).getOperand()) instanceof PsiReferenceExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)expression2)) {
            expression2 = operand2;
        }
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
        PsiVariable initialization = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        if (initialization == null) {
            return false;
        }
        if (!(initialization instanceof PsiResourceVariable) && variable instanceof PsiResourceVariable) {
            return false;
        }
        if (!(initialization instanceof PsiLocalVariable || initialization instanceof PsiParameter || VariableAccessUtils.isFinalChain(reference) && ReferencesSearch.search((PsiElement)variable).findAll().size() == 1)) {
            return false;
        }
        PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (containingScope == null) {
            return false;
        }
        if (VariableAccessUtils.variableMayChange(containingScope, null, (PsiVariable)variable)) {
            return false;
        }
        if (VariableAccessUtils.variableMayChange(containingScope, PsiUtil.skipParenthesizedExprDown((PsiExpression)reference.getQualifierExpression()), initialization)) {
            return false;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)containingScope.getProject()).getResolveHelper();
        String initializationName = initialization.getName();
        if (initializationName == null) {
            return false;
        }
        boolean finalVariableIntroduction = !initialization.hasModifierProperty("final") && variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher((PsiElement)initialization) && !HighlightControlFlowUtil.isEffectivelyFinal(initialization, (PsiElement)containingScope, null) && HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)containingScope, null);
        PsiType variableType = variable.getType();
        PsiType initializationType = initialization.getType();
        boolean sameType = Comparing.equal((Object)variableType, (Object)initializationType);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)containingScope))) {
            PsiElement resolve2;
            PsiElement parent;
            PsiElement element;
            PsiElement refElement = ref.getElement();
            if (finalVariableIntroduction && (element = PsiTreeUtil.getParentOfType((PsiElement)refElement, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && PsiTreeUtil.isAncestor((PsiElement)containingScope, (PsiElement)element, (boolean)true)) {
                return false;
            }
            if (resolveHelper.resolveReferencedVariable(initializationName, refElement) != initialization) {
                return false;
            }
            if (sameType || !((parent = refElement.getParent()) instanceof PsiReferenceExpression) || !((resolve2 = ((PsiReferenceExpression)parent).resolve()) instanceof PsiMember) || !((PsiMember)resolve2).hasModifierProperty("private")) continue;
            return false;
        }
        return !TypeConversionUtil.boxingConversionApplicable((PsiType)variableType, (PsiType)initializationType);
    }

    public static List<PsiVariable> findDeclaredVariables(@NotNull PsiStatement statement) {
        final ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitVariable(PsiVariable variable) {
                variables.add(variable);
                super.visitVariable(variable);
            }
        });
        return variables;
    }

    private static boolean isFinalChain(PsiReferenceExpression reference) {
        PsiElement element;
        while ((element = reference.resolve()) instanceof PsiField) {
            if (!((PsiField)element).hasModifierProperty("final")) {
                return false;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)reference.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            reference = (PsiReferenceExpression)qualifier;
        }
        return true;
    }

    private static boolean variableMayChange(PsiCodeBlock containingScope, PsiExpression qualifier, PsiVariable variable) {
        while (variable != null) {
            if (!variable.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(variable, (PsiElement)containingScope, false)) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) break;
            PsiReferenceExpression qualifierReference = (PsiReferenceExpression)qualifier;
            qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierReference.getQualifierExpression());
            variable = (PsiVariable)ObjectUtils.tryCast((Object)qualifierReference.resolve(), PsiVariable.class);
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean canUseAsNonFinal(PsiLocalVariable var) {
        if (var == null) {
            return false;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        return block != null && ReferencesSearch.search((PsiElement)var).allMatch(ref -> {
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            return context == null || PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)block, (boolean)false);
        });
    }

    private static class VariableCollectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiVariable> usedVariables = new HashSet<PsiVariable>();

        private VariableCollectingVisitor() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            this.usedVariables.add(variable);
        }

        public Set<PsiVariable> getUsedVariables() {
            return this.usedVariables;
        }
    }
}

