/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.BaseInspection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMatcher {
    private final List<String> myMethodNamePatterns = new ArrayList<String>();
    private final List<String> myClassNames = new ArrayList<String>();
    private final Map<String, Pattern> myPatternCache = new HashMap<String, Pattern>();
    private final boolean myWriteDefaults;
    private final String myOptionName;
    private String myDefaultSettings = null;

    public MethodMatcher() {
        this(false, "METHOD_MATCHER_CONFIG");
    }

    public MethodMatcher(boolean writeDefaults, String optionName) {
        this.myWriteDefaults = writeDefaults;
        this.myOptionName = optionName;
    }

    public MethodMatcher add(@NonNls @NotNull String className2, @NonNls @NotNull String methodNamePattern) {
        this.myClassNames.add(className2);
        this.myMethodNamePatterns.add(methodNamePattern);
        return this;
    }

    public void add(@NotNull PsiMethodCallExpression expression2) {
        PsiMethod method = expression2.resolveMethod();
        if (method != null) {
            this.add(method);
        }
    }

    public void add(@NotNull PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        String fqName = aClass.getQualifiedName();
        int index = this.myClassNames.indexOf(fqName);
        String methodName = method.getName();
        if (index < 0) {
            this.myClassNames.add(fqName);
            this.myMethodNamePatterns.add(methodName);
        } else {
            String[] names2;
            String pattern = this.myMethodNamePatterns.get(index);
            if (pattern.isEmpty()) {
                this.myMethodNamePatterns.set(index, methodName);
                return;
            }
            if (".*".equals(pattern)) {
                return;
            }
            for (String name2 : names2 = pattern.split("\\|")) {
                if (!methodName.equals(name2)) continue;
                return;
            }
            this.myMethodNamePatterns.set(index, pattern + '|' + methodName);
        }
        ProjectInspectionProfileManager.getInstance((Project)method.getProject()).fireProfileChanged();
    }

    @NotNull
    protected String getOptionName() {
        return this.myOptionName;
    }

    public List<String> getMethodNamePatterns() {
        return this.myMethodNamePatterns;
    }

    public List<String> getClassNames() {
        return this.myClassNames;
    }

    public boolean matches(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        int size = this.myMethodNamePatterns.size();
        for (int i = 0; i < size; ++i) {
            String className2;
            Pattern pattern = this.getPattern(i);
            if (pattern == null || !pattern.matcher(methodName).matches() || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)(className2 = this.myClassNames.get(i)))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(PsiCall call) {
        return this.matches(call.resolveMethod());
    }

    private Pattern getPattern(int i) {
        String methodNamePattern = this.myMethodNamePatterns.get(i);
        Pattern pattern = this.myPatternCache.get(methodNamePattern);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.myPatternCache.put(methodNamePattern, pattern);
            }
            catch (NullPointerException | PatternSyntaxException ignore) {
                return null;
            }
        }
        return pattern;
    }

    public MethodMatcher finishDefault() {
        if (this.myDefaultSettings != null) {
            throw new IllegalStateException();
        }
        this.myDefaultSettings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        return this;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        String settings = null;
        for (Element option : node.getChildren("option")) {
            if (!option.getAttributeValue("name").equals(this.getOptionName())) continue;
            settings = option.getAttributeValue("value");
            break;
        }
        if (settings == null) {
            return;
        }
        this.myPatternCache.clear();
        this.myClassNames.clear();
        this.myMethodNamePatterns.clear();
        BaseInspection.parseString(settings, this.myClassNames, this.myMethodNamePatterns);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        String settings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        if (!this.myWriteDefaults && settings.equals(this.myDefaultSettings)) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", this.getOptionName()).setAttribute("value", settings));
    }
}

