/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconvertibleTypesChecker {
    @Contract(pure=true)
    @Nullable
    public static TypeMismatch checkTypes(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        if (TypeUtils.areConvertible(leftType, rightType) || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            return InconvertibleTypesChecker.deepCheck(leftType, rightType, lookForMutualSubclass);
        }
        return new TypeMismatch(leftType, rightType, false);
    }

    @Nullable
    public static TypeMismatch deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        return InconvertibleTypesChecker.deepCheck(leftType, rightType, new HashSet<Couple<PsiType>>(), lookForMutualSubclass);
    }

    @Nullable
    private static TypeMismatch deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull Set<Couple<PsiType>> checked, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        if (leftType instanceof PsiCapturedWildcardType) {
            leftType = ((PsiCapturedWildcardType)leftType).getUpperBound();
        }
        if (rightType instanceof PsiCapturedWildcardType) {
            rightType = ((PsiCapturedWildcardType)rightType).getUpperBound();
        }
        if (!checked.add((Couple<PsiType>)Couple.of((Object)leftType, (Object)rightType))) {
            return null;
        }
        if (leftType.isAssignableFrom(rightType) || rightType.isAssignableFrom(leftType)) {
            return null;
        }
        PsiClass leftClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)leftType);
        PsiClass rightClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rightType);
        if (leftClass == null || rightClass == null) {
            return null;
        }
        if (!rightClass.isInterface()) {
            PsiClass tmp = leftClass;
            leftClass = rightClass;
            rightClass = tmp;
        }
        if (leftClass == rightClass || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            PsiType[] rightParameters;
            PsiType[] leftParameters;
            if (leftType instanceof PsiClassType && rightType instanceof PsiClassType && (leftParameters = ((PsiClassType)leftType).getParameters()).length == (rightParameters = ((PsiClassType)rightType).getParameters()).length) {
                int length = leftParameters.length;
                for (int i = 0; i < length; ++i) {
                    PsiType leftParameter = leftParameters[i];
                    PsiType rightParameter = rightParameters[i];
                    if (!TypeUtils.areConvertible(leftParameter, rightParameter) && !TypeUtils.mayBeEqualByContract(leftParameter, rightParameter)) {
                        return new TypeMismatch(leftType, rightType, false);
                    }
                    TypeMismatch mismatch = InconvertibleTypesChecker.deepCheck(leftParameter, rightParameter, checked, lookForMutualSubclass);
                    if (mismatch == null) continue;
                    return mismatch;
                }
            }
        } else {
            if (TypeUtils.cannotBeEqualByContract(leftType, rightType)) {
                return new TypeMismatch(leftType, rightType, false);
            }
            if (lookForMutualSubclass != LookForMutualSubclass.NEVER && !InheritanceUtil.existsMutualSubclass(leftClass, rightClass, lookForMutualSubclass == LookForMutualSubclass.IF_CHEAP)) {
                return new TypeMismatch(leftType, rightType, true);
            }
        }
        return null;
    }

    public static class TypeMismatch {
        @NotNull
        private final PsiType myLeft;
        @NotNull
        private final PsiType myRight;
        private final boolean myConvertible;

        private TypeMismatch(@NotNull PsiType left, @NotNull PsiType right, boolean convertible) {
            this.myLeft = left;
            this.myRight = right;
            this.myConvertible = convertible;
        }

        @NotNull
        public PsiType getLeft() {
            return this.myLeft;
        }

        @NotNull
        public PsiType getRight() {
            return this.myRight;
        }

        public boolean isConvertible() {
            return this.myConvertible;
        }
    }

    public static enum LookForMutualSubclass {
        NEVER,
        ALWAYS,
        IF_CHEAP;

    }
}

