/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UseOfProcessBuilderInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("use.processbuilder.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProcessBuilderVisitor();
    }

    private static class ProcessBuilderVisitor
    extends BaseInspectionVisitor {
        private ProcessBuilderVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            PsiType type2 = variable.getType();
            String typeString = type2.getCanonicalText();
            if (!"java.lang.ProcessBuilder".equals(typeString)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            super.visitNewExpression(newExpression);
            PsiType type2 = newExpression.getType();
            if (type2 == null) {
                return;
            }
            String typeString = type2.getCanonicalText();
            if (!"java.lang.ProcessBuilder".equals(typeString)) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

