/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class CanBeStaticVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean canBeStatic = true;

    CanBeStaticVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (this.canBeStatic) {
            super.visitElement(element);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        if (!this.canBeStatic) {
            return;
        }
        super.visitReferenceExpression(ref);
        PsiElement element = ref.resolve();
        if (element instanceof PsiModifierListOwner && !((PsiModifierListOwner)element).hasModifierProperty("static")) {
            this.canBeStatic = false;
        }
    }

    public boolean canBeStatic() {
        return this.canBeStatic;
    }
}

