/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisjointPackageInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        Set<RefClass> childClasses = refPackage.getChildren().stream().filter(child -> child instanceof RefClass).map(child -> (RefClass)child).collect(Collectors.toSet());
        if (childClasses.isEmpty()) {
            return null;
        }
        Set<Set<RefClass>> components = DisjointPackageInspection.createComponents(refPackage, childClasses);
        if (components.size() == 1) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("disjoint.package.problem.descriptor", refPackage.getQualifiedName(), components.size());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static Set<Set<RefClass>> createComponents(RefPackage aPackage, Set<RefClass> classes2) {
        HashSet<RefClass> allClasses = new HashSet<RefClass>(classes2);
        HashSet<Set<RefClass>> out = new HashSet<Set<RefClass>>();
        while (!allClasses.isEmpty()) {
            RefClass seed = (RefClass)allClasses.iterator().next();
            allClasses.remove(seed);
            HashSet<RefClass> currentComponent = new HashSet<RefClass>();
            currentComponent.add(seed);
            ArrayList<RefClass> pendingClasses = new ArrayList<RefClass>();
            pendingClasses.add(seed);
            while (!pendingClasses.isEmpty()) {
                RefClass classToProcess = (RefClass)pendingClasses.remove(0);
                Set<RefClass> relatedClasses = DisjointPackageInspection.getRelatedClasses(aPackage, classToProcess);
                for (RefClass relatedClass : relatedClasses) {
                    if (currentComponent.contains(relatedClass) || pendingClasses.contains(relatedClass)) continue;
                    currentComponent.add(relatedClass);
                    pendingClasses.add(relatedClass);
                    allClasses.remove(relatedClass);
                }
            }
            out.add(currentComponent);
        }
        return out;
    }

    private static Set<RefClass> getRelatedClasses(RefPackage aPackage, RefClass classToProcess) {
        HashSet<RefClass> out = new HashSet<RefClass>();
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(classToProcess);
        for (RefClass dependency : dependencies) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependency)) continue;
            out.add(dependency);
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(classToProcess);
        for (RefClass dependent : dependents) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependent)) continue;
            out.add(dependent);
        }
        return out;
    }

    private static boolean packageContainsClass(RefPackage aPackage, RefClass aClass) {
        return aPackage.equals(RefJavaUtil.getPackage((RefEntity)aClass));
    }
}

