/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.ReplaceEmptyArrayToConstantFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryEmptyArrayUsageInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.for.zero.length.array.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceEmptyArrayToConstantFix((PsiClass)infos[0], (PsiField)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiType arrayType;
                PsiClass typeClass;
                PsiType type2;
                if (ConstructionUtils.isEmptyArrayInitializer((PsiExpression)expression2) && (type2 = expression2.getType()) instanceof PsiArrayType && (typeClass = PsiTypesUtil.getPsiClass((PsiType)(arrayType = ((PsiArrayType)type2).getComponentType()))) != null) {
                    for (PsiField field : typeClass.getFields()) {
                        PsiModifierList modifiers = field.getModifierList();
                        if (modifiers == null || typeClass.isEquivalentTo(PsiTreeUtil.findFirstParent((PsiElement)expression2, e -> e instanceof PsiClass)) || !modifiers.hasModifierProperty("public") || !field.getType().equals(type2) || !CollectionUtils.isConstantEmptyArray(field)) continue;
                        this.registerError((PsiElement)expression2, typeClass, field);
                        return;
                    }
                }
                super.visitNewExpression(expression2);
            }
        };
    }
}

